
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.util.ArrayList;

/**
 * @author roberthaynes
 *
 */
public interface ITableColumn extends Comparable{

    String getTableName();

    void setOrder(int order);

    int getOrder();

    void setDisplay(String display);

    String getDisplay();

    void setTableName(String tableName);

    String getColName();

    void setColName(String colName);

    String getLength();

    void setLength(String length);

    String getDefaultValue();

    void setDefaultValue(String defaultValue);

    boolean isNotNull();

    void setNotNull(boolean notNull);

    void setSpecialUse(String su);

    void setPrimaryKey(boolean primaryKey);

    boolean isPrimaryKey();

    int getLabelPos();

    void setLabelPos(int labelPos);

    //geofield pos is the order of the address fields used to construct an address
    //-1 is latitute, -2 is longitude
    void setGeoFieldPos(int integer);

    int getGeoFieldPos();

    void setAction(String action);

    String getAction();

    boolean isFilteredIndex();

    void setFilteredIndex(boolean value);

    int compareTo(Object o);

    void setForeignKey(String keyText);

    String getForeignKey();

    String getSpecialUse();

    boolean isSequence();

    void setSequence(boolean isSeq);

    boolean isIcon();

    void setIcon(Boolean boolean1);

    boolean isEID();

    void setEID(boolean isEID);

    boolean isSystem();

    void setSystem(boolean is);

    String getLookup();

    void setLookup(String lookup);

    String getLookupColumns();

    void setLookupColumns(String lookupColumns);

    String getLookupFallback();

    String getMetric();

    void setLookupFallback(String fallback);

    void setMetric(String metric);

    boolean isIgnorePrepend();

    void setIgnorePrepend(boolean ig);

    void setDisplayType(String attribute);

    void setRunBefore(String attribute);

    void setRunAfter(String attribute);

    String getDisplayType();

    String getRunBefore();

    String getRunAfter();

    String getDisplayPage();

    void setDisplayPage(String attribute);

    void setSensitivityField(boolean sensitive);

    boolean isSensitivityField();

    void setPurposeColumnMap(ArrayList<PurposeColumnMap> _pcms);

    ArrayList<PurposeColumnMap> getPurposeColumnMap();

    void setLastUpdated(boolean lastUpdated);

    boolean isLastUpdated();

}