/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.io.Serializable;

public class Index implements Serializable, IIndex{
	private String indexName;
	private String purposeName;
	private boolean match;
	private boolean search;
	private int keyThreshold;
	private boolean exactIndex;
	private int instance;
	
	public Index(){
		
	}
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#getIndexName()
	 */
	@Override
	public String getIndexName() {
		return indexName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#setIndexName(java.lang.String)
	 */
	@Override
	public void setIndexName(String indexName) {
		this.indexName = indexName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#getPurposeName()
	 */
	@Override
	public String getPurposeName() {
		return purposeName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#setPurposeName(java.lang.String)
	 */
	@Override
	public void setPurposeName(String purposeName) {
		this.purposeName = purposeName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#isMatch()
	 */
	@Override
	public boolean isMatch() {
		return match;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#setMatch(boolean)
	 */
	@Override
	public void setMatch(boolean isMatch) {
		this.match = isMatch;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#isSearch()
	 */
	@Override
	public boolean isSearch() {
		return search;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#setSearch(boolean)
	 */
	@Override
	public void setSearch(boolean isSearch) {
		this.search = isSearch;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#setKeyThreshold(int)
	 */
	@Override
	public void setKeyThreshold(int keyThres) {
		this.keyThreshold=keyThres;
		
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#getKeyThreshold()
	 */
	@Override
	public int getKeyThreshold(){
		return keyThreshold;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#setExactIndex(boolean)
	 */
	@Override
	public void setExactIndex(boolean exactIndex) {
		this.exactIndex=exactIndex;
		
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#isExactIndex()
	 */
	@Override
	public boolean isExactIndex(){
		return exactIndex;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#getInstance()
	 */
	@Override
	public int getInstance() {
		return instance;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IIndex#setInstance(int)
	 */
	@Override
	public void setInstance(int i){
		instance=i;
	}
}
