/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;

import com.entitystream.monster.db.Document;
import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.metadata.IdentizaSettings;
import com.entitystream.identiza.wordlist.RuleFactory;
import com.entitystream.identiza.wordlist.RuleSet;

public class PurposeColumn implements Serializable{
	private String purposeName;
	private String column;	
	private int gradientType;
	private RuleSet ruleSet;
	private String matchClass;
	private String challengeType;
	private MatchProcInterface purposeClass;
	private int minWidth;
	private int maxWidth;
	private boolean mandatory=true;
	private String ruleFunction;

	public PurposeColumn(){

	}
	public String getPurposeName() {
		return purposeName;
	}
	public void setPurposeName(String name) {
		this.purposeName = name;
	}
	public String getColumn() {
		return column;
	}
	public void setColumn(String column) {
		this.column = column;
		if (this.purposeClass!=null)
			purposeClass.setRuleFunction(ruleFunction);

	}



	public String getMatchClass() {
		return matchClass;
	}

	public void setMatchClass(String classname) {
		if (classname==null || classname.equalsIgnoreCase("null"))
			classname="MatchString";
		matchClass = classname;
		pushRuleSet(RuleFactory.getInstance(matchClass));
		try {

			purposeClass=getRealClass(classname);

			if (purposeClass!=null) {
				purposeClass.setGradient(getGradientType());
				purposeClass.setRuleSet(ruleSet);
				purposeClass.init(ruleFunction);
			}
			// purposeClass.loadWeights(matchProcName,schema.getGroupName(),schema,true);
		} catch (Exception e2) {
			e2.printStackTrace();
		}
	}

	private MatchProcInterface getRealClass(String origname) throws Exception {
		//some matchclasses do not exist, they are inherited from a base class, this is so the rules can be different 
		String name=origname;
		if (!origname.contains("."))
			name = "com.entitystream.identiza.entity.resolve.types." + name;

		Class clazz=null;
		try{
			clazz = Class.forName(name);
		} catch (ClassNotFoundException cnfe) {
			//try harder
			
		}
		if (clazz!=null) {
			Constructor cons = clazz.getConstructor(String.class);
			MatchBase _purposeClass = (MatchBase) cons.newInstance(ruleFunction);
			return _purposeClass;
		} 
		return null;
	}

	public int getGradientType() {
		return gradientType;
	}

	public void setGradientType(int g) {
		gradientType = g;
	}

	public MatchProcInterface createMatchProc() {
		if (purposeClass==null)
			setMatchClass(getMatchClass());
		return purposeClass;
	}
	public void setMinWidth(int width) {
		this.minWidth=width;

	}
	public void setMaxWidth(int width) {
		this.maxWidth=width;

	}
	public int getMaxWidth() {
		if (maxWidth>0)
			return maxWidth;
		else return 3;
	}
	public int getMinWidth() {
		if(minWidth>0)
			return minWidth;
		else return 1;
	}
	public void pushRuleSet(RuleSet ruleSet) {
		this.ruleSet=ruleSet;
	}
	public RuleSet popRuleSet() {
		return ruleSet;
	}
	public boolean isMandatory() {
		return mandatory;
	}
	public void setMandatory(boolean mandatory) {
		this.mandatory = mandatory;
	}
	public String getChallengeType() {
		return challengeType;
	}
	public void setChallengeType(String challengeType) {
		this.challengeType = challengeType;
	}
	public String getRuleFunction() {
		return ruleFunction;
	}
	public void setRuleFunction(String rf) {
		this.ruleFunction=rf;
	}

}
