/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.io.Serializable;


public class PurposeColumnMap implements Serializable, Comparable{
	private String purposeName;
	private String purposeColumn;
	private String tableName;
	private String tableColumn;
	private int columnOrder;
	private String schemaName;
	public PurposeColumnMap(){
	}
	
	public PurposeColumnMap(String schemaName){
		this.schemaName=schemaName;
	}
	
	public String getPurposeName() {
		return purposeName;
	}
	public void setPurposeName(String purposeName) {
		this.purposeName = purposeName;
	}
	
	public String getPurposeColumn() {
		return purposeColumn;
	}
	public void setPurposeColumn(String purposeColumn) {
		this.purposeColumn = purposeColumn;
	}
	public String getTableName() {
		return tableName;
	}
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
	public String getTableColumn() {
		return tableColumn;
	}
	public void setTableColumn(String tableColumn) {
		this.tableColumn = tableColumn;
	}
	public void setColumnOrder(int columnOrder) {
		this.columnOrder = columnOrder;
	}
	public int getColumnOrder() {
		return columnOrder;
	}
	

	@Override
	public int compareTo(Object o) {
		return this.getColumnOrder()-((PurposeColumnMap)o).getColumnOrder();
	}
	public String toJSON() {
		StringBuilder sb = new StringBuilder();
		sb.append("{");
		sb.append("'purposeColumn':'"+this.getPurposeColumn()+"',");
		sb.append("'purposeName':'"+this.getPurposeName()+"',");
		sb.append("'tableName':'"+this.getTableName()+"',");
		sb.append("'tableColumn':'"+this.getTableColumn()+"',");
		sb.append("'columnOrder':"+this.getColumnOrder()+",");
		sb.append("'schemaName':'"+this.getSchemaName()+"'");
		sb.append("}");
		return sb.toString();
	}

	public String getSchemaName() {
		
		return schemaName;
	}

	public static PurposeColumnMap fromDocument(com.entitystream.monster.db.Document pcmd){
		PurposeColumnMap pcm = new PurposeColumnMap(pcmd.getString("schemaName"));
		pcm.purposeColumn=pcmd.getString("purposeColumn");
		pcm.purposeName=pcmd.getString("purposeName");
		pcm.tableColumn=pcmd.getString("tableColumn");
		pcm.tableName=pcmd.getString("tableName");
		pcm.setColumnOrder(pcmd.getInteger("columnOrder",1));
		
		return pcm;
	}

	public void setSchemaName(String schemaName2) {
		this.schemaName=schemaName2;
		
	}
	
}
