/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.io.Serializable;
import java.util.ArrayList;

import com.google.gson.JsonObject;

public class Rule implements Serializable, IRule{
	//private String tableName;
	private int order;
	private String action;
	private double highScore;
	private double lowScore;
	private ArrayList<RulePurpose> rulePurpose;
	private String actionText;
	private boolean active;
	private int systemMatchType;
	private boolean canMatchSameSystem=true;

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#getAction()
	 */
	@Override
	public String getAction() {
		return action;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#isActive()
	 */
	@Override
	public boolean isActive(){
		return active;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setActive(boolean)
	 */
	@Override
	public void setActive(boolean active){
		this.active=active;
	}	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setAction(java.lang.String)
	 */
	@Override
	public void setAction(String action) {
		this.action = action;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#getActionText()
	 */
	@Override
	public String getActionText() {
		return actionText;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setActionText(java.lang.String)
	 */
	@Override
	public void setActionText(String actionText) {
		this.actionText = actionText;
	}
	public Rule(){
		rulePurpose = new ArrayList<RulePurpose>();
	}
	
	public Rule(/*String tableName,*/ int order, String action, double lowScore, double highScore, String actionText, boolean active, String systemMatchType, boolean canMatchSameSystem){
		//this.tableName = tableName;
		this.order = order;
		this.action=action;
		this.highScore=highScore;
		this.lowScore=lowScore;
		this.actionText=actionText;
		this.active=active;
		this.convertSystemMatchType(systemMatchType);
		this.canMatchSameSystem=canMatchSameSystem;
		rulePurpose = new ArrayList<RulePurpose>();

	}
	
	//public String getTableName() {
	//	return tableName;
	//}
	//public void setTableName(String tableName) {
	//	this.tableName = tableName;
	//}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#getOrder()
	 */
	@Override
	public int getOrder() {
		return order;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setOrder(int)
	 */
	@Override
	public void setOrder(int order) {
		this.order = order;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#getRulePurpose()
	 */
	@Override
	public ArrayList<RulePurpose> getRulePurpose() {
		return rulePurpose;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setRulePurpose(java.util.ArrayList)
	 */
	@Override
	public void setRulePurpose(ArrayList<RulePurpose> rulePurpose) {
		this.rulePurpose = rulePurpose;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#getHighScore()
	 */
	@Override
	public double getHighScore() {
		// TODO Auto-generated method stub
		return highScore;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#getLowScore()
	 */
	@Override
	public double getLowScore() {
		// TODO Auto-generated method stub
		return lowScore;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setLowScore(java.lang.Double)
	 */
	@Override
	public void setLowScore(Double double1) {
		lowScore = double1;
	}
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setHighScore(java.lang.Double)
	 */
	@Override
	public void setHighScore(Double double1) {
		highScore = double1;
		
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#getSystemMatchType()
	 */
	@Override
	public int getSystemMatchType() {
		return systemMatchType;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#convertSystemMatchType(java.lang.String)
	 */
	@Override
	public void convertSystemMatchType(String systemMatchType){
		this.systemMatchType=0; //ALL
		if (systemMatchType!=null && systemMatchType.length()>0){
			if (systemMatchType.equalsIgnoreCase("ALL"))
				this.systemMatchType=0;
			else if (systemMatchType.equalsIgnoreCase("INTERNALTOINTERNAL"))
				this.systemMatchType=121;
			else if (systemMatchType.equalsIgnoreCase("INTERNALTOEXTERNAL"))
				this.systemMatchType=122;
			if (systemMatchType.equalsIgnoreCase("EXTERNALTOEXTERNAL"))
				this.systemMatchType=222;
		}
	}
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setSystemMatchType(int)
	 */
	@Override
	public void setSystemMatchType(int smt){
		this.systemMatchType=smt;
	}
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#isMatchSameSystem()
	 */
	@Override
	public boolean isMatchSameSystem() {
		// TODO Auto-generated method stub
		return canMatchSameSystem;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#setMatchSameSystem(boolean)
	 */
	@Override
	public void setMatchSameSystem(boolean b){
		canMatchSameSystem=b;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.IRule#getHashKey()
	 */
	@Override
	public String getHashKey() {
		StringBuilder ret=new StringBuilder();
		for (RulePurpose rp : rulePurpose)
			ret.append(rp.getPurposeName() + rp.isMandatory() +":");
		return ret.toString();
	}
	@Override
	public JsonObject toJSON() {
		JsonObject json = new JsonObject();
		json.addProperty("canMatchSameSystem", isMatchSameSystem());
		json.addProperty("systemMatchType", getSystemMatchType());
		json.addProperty("lowScore", getLowScore());
		json.addProperty("highScore", getHighScore());
		json.addProperty("actionText", getActionText());

		return json;
	}

}

