/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.io.Serializable;

public class RulePurpose implements Serializable{
   private String purposeName;
   private boolean mandatory;
   private boolean negate;
   private double acceptWeight=1.0d;
   private double rejectWeight=1.0d;
   
public RulePurpose(String purposeName, boolean mandatory, boolean negate){
	this.purposeName=purposeName;
	this.mandatory=mandatory;
	this.negate=negate;
}

public RulePurpose(){
	
}

public String getPurposeName() {
	return purposeName;
}
public void setPurposeName(String purposeName) {
	this.purposeName = purposeName;
}
public boolean isMandatory() {
	return mandatory;
}
public void setMandatory(boolean mandatory) {
	this.mandatory = mandatory;
}

public void setNegate(boolean negate) {
	this.negate = negate;
}

public boolean isNegate() {
	return negate;
}

public double getAcceptWeight() {
	return acceptWeight;
}

public void setAcceptWeight(double acceptWeight) {
	this.acceptWeight = acceptWeight;
}

public double getRejectWeight() {
	return rejectWeight;
}

public void setRejectWeight(double rejectWeight) {
	this.rejectWeight = rejectWeight;
}
}
