/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.io.Serializable;
import java.util.ArrayList;

public class TableColumn implements Serializable, ITableColumn{
	private String tableName;
	private String colName;
	private String length;
	private String defaultValue;
	private boolean primaryKey;
	private int labelPos;
	private boolean notNull;
	private int geoFieldPos;
	private String action;
	private boolean isFilteredIndex;
	private String display;
	private int order;
	private String foreignKey;
	private String specialUse;
	private boolean isSequence=false;
	private boolean isIcon;
	private boolean isEID;
	private boolean isSystem;
	private String lookup;
	private String lookupColumns;
	private String lookupFallback;
	private boolean ignorePrepend=false;
	private String metric;
	private String displayType;
	private String runBefore;
	private String runAfter;
	private String displayPage;
	private boolean sensitive=false;
	private ArrayList<PurposeColumnMap> pcms=new ArrayList<PurposeColumnMap>();
	private boolean lastUpdated=false;

	public TableColumn(){
		
	}
	
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getTableName()
	 */
	@Override
	public String getTableName() {
		return nullToEmpty(tableName);
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setOrder(int)
	 */
	@Override
	public void setOrder(int order){
		this.order=order;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getOrder()
	 */
	@Override
	public int getOrder(){
		return order;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setDisplay(java.lang.String)
	 */
	@Override
	public void setDisplay (String display){
		this.display=display;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getDisplay()
	 */
	@Override
	public String getDisplay(){
		return nullToEmpty(display);
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setTableName(java.lang.String)
	 */
	@Override
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getColName()
	 */
	@Override
	public String getColName() {
		return nullToEmpty(colName);
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setColName(java.lang.String)
	 */
	@Override
	public void setColName(String colName) {
		this.colName = colName;
		if (display==null)
			display=colName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getLength()
	 */
	@Override
	public String getLength() {
		return length;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setLength(java.lang.String)
	 */
	@Override
	public void setLength(String length) {
		this.length = length;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getDefaultValue()
	 */
	@Override
	public String getDefaultValue() {
		return nullToEmpty(defaultValue);
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setDefaultValue(java.lang.String)
	 */
	@Override
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isNotNull()
	 */
	@Override
	public boolean isNotNull() {
		return notNull;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setNotNull(boolean)
	 */
	@Override
	public void setNotNull(boolean notNull) {
		this.notNull = notNull;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setSpecialUse(java.lang.String)
	 */
	@Override
	public void setSpecialUse(String su){
		this.specialUse=su;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setPrimaryKey(boolean)
	 */
	@Override
	public void setPrimaryKey(boolean primaryKey) {
		this.primaryKey = primaryKey;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isPrimaryKey()
	 */
	@Override
	public boolean isPrimaryKey() {
		return primaryKey;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getLabelPos()
	 */
	@Override
	public int getLabelPos() {
		return labelPos;
	} 
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setLabelPos(int)
	 */
	@Override
	public void setLabelPos(int labelPos) {
		this.labelPos = labelPos;
	}

	//geofield pos is the order of the address fields used to construct an address
	//-1 is latitute, -2 is longitude
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setGeoFieldPos(int)
	 */
	@Override
	public void setGeoFieldPos(int integer) {
		this.geoFieldPos=integer;	
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getGeoFieldPos()
	 */
	@Override
	public int getGeoFieldPos() {
		return geoFieldPos;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setAction(java.lang.String)
	 */
	@Override
	public void setAction(String action) {
		this.action=action;
	}
	
	private String nullToEmpty(String in){
		if (in==null || in.equalsIgnoreCase("null"))
			return "";
		else
			return in;
	}
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getAction()
	 */
	@Override
	public String getAction(){
		return nullToEmpty(action);
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isFilteredIndex()
	 */
	@Override
	public boolean isFilteredIndex() {
		return isFilteredIndex;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setFilteredIndex(boolean)
	 */
	@Override
	public void setFilteredIndex(boolean value){
		isFilteredIndex=value;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#compareTo(java.lang.Object)
	 */
	@Override
	public int compareTo(Object o) {
		//if column is the index then its always lower
		if (((TableColumn)o).primaryKey){
			if (this.primaryKey)
				return 0;
			else 
				return 1;
		} else if (primaryKey){
			return -1;
		} else  

			return (new Integer(order)).compareTo(((ITableColumn)o).getOrder());
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setForeignKey(java.lang.String)
	 */
	@Override
	public void setForeignKey(String keyText){
		this.foreignKey=keyText;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getForeignKey()
	 */
	@Override
	public String getForeignKey() {
		if (foreignKey!=null && foreignKey.length()>0 && !foreignKey.equalsIgnoreCase("null"))
		   return foreignKey;
		else return null;
	}
	
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getSpecialUse()
	 */
	@Override
	public String getSpecialUse() {
		// TODO Auto-generated method stub
		return nullToEmpty(specialUse);
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isSequence()
	 */
	@Override
	public boolean isSequence() {
		// TODO Auto-generated method stub
		return isSequence;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setSequence(boolean)
	 */
	@Override
	public void setSequence(boolean isSeq) {
		// TODO Auto-generated method stub
		isSequence=isSeq;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isIcon()
	 */
	@Override
	public boolean isIcon() {
		// TODO Auto-generated method stub
		return isIcon;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setIcon(java.lang.Boolean)
	 */
	@Override
	public void setIcon(Boolean boolean1) {
		// TODO Auto-generated method stub
		isIcon=boolean1;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isEID()
	 */
	@Override
	public boolean isEID() {
		// TODO Auto-generated method stub
		return isEID;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setEID(boolean)
	 */
	@Override
	public void setEID(boolean isEID){
		this.isEID=isEID;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isSystem()
	 */
	@Override
	public boolean isSystem() {
		return isSystem;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setSystem(boolean)
	 */
	@Override
	public void setSystem(boolean is){
		isSystem=is;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getLookup()
	 */
	@Override
	public String getLookup() {
		return lookup;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setLookup(java.lang.String)
	 */
	@Override
	public void setLookup(String lookup) {
		this.lookup = lookup;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getLookupColumns()
	 */
	@Override
	public String getLookupColumns() {
		return lookupColumns;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setLookupColumns(java.lang.String)
	 */
	@Override
	public void setLookupColumns(String lookupColumns) {
		this.lookupColumns = lookupColumns;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getLookupFallback()
	 */
	@Override
	public String getLookupFallback() {
		return lookupFallback;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getMetric()
	 */
	@Override
	public String getMetric() {
		return nullToEmpty(metric);
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setLookupFallback(java.lang.String)
	 */
	@Override
	public void setLookupFallback(String fallback){
		lookupFallback=fallback;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setMetric(java.lang.String)
	 */
	@Override
	public void setMetric(String metric){
		this.metric=metric;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isIgnorePrepend()
	 */
	@Override
	public boolean isIgnorePrepend() {
		return ignorePrepend;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setIgnorePrepend(boolean)
	 */
	@Override
	public void setIgnorePrepend(boolean ig){
		ignorePrepend=ig;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setDisplayType(java.lang.String)
	 */
	@Override
	public void setDisplayType(String attribute) {
		displayType=attribute;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setRunBefore(java.lang.String)
	 */
	@Override
	public void setRunBefore(String attribute) {
		runBefore=attribute;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setRunAfter(java.lang.String)
	 */
	@Override
	public void setRunAfter(String attribute) {
		runAfter=attribute;		
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getDisplayType()
	 */
	@Override
	public String getDisplayType() {
		return nullToEmpty(displayType);
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getRunBefore()
	 */
	@Override
	public String getRunBefore() {
		return nullToEmpty(runBefore);
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getRunAfter()
	 */
	@Override
	public String getRunAfter() {
		return nullToEmpty(runAfter);		
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getDisplayPage()
	 */
	@Override
	public String getDisplayPage() {	
		if (nullToEmpty(displayPage).length()>0)
			return nullToEmpty(displayPage);
		else return tableName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setDisplayPage(java.lang.String)
	 */
	@Override
	public void setDisplayPage(String attribute) {	
		displayPage=attribute;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setSensitivityField(boolean)
	 */
	@Override
	public void setSensitivityField(boolean sensitive) {
		this.sensitive=sensitive;

	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isSensitivityField()
	 */
	@Override
	public boolean isSensitivityField() {
		return sensitive;
	}
	

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setPurposeColumnMap(java.util.ArrayList)
	 */
	@Override
	public void setPurposeColumnMap(ArrayList<PurposeColumnMap> _pcms) {
		this.pcms=_pcms;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#getPurposeColumnMap()
	 */
	@Override
	public ArrayList<PurposeColumnMap> getPurposeColumnMap() {
		return this.pcms;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#setLastUpdated(boolean)
	 */
	@Override
	public void setLastUpdated(boolean lastUpdated){
		this.lastUpdated=lastUpdated;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.metadata.ITableColumn#isLastUpdated()
	 */
	@Override
	public boolean isLastUpdated() {
		return lastUpdated;
	}
}
