/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.processing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.entitystream.identiza.entity.resolve.match.Match;


public class Candidate implements Serializable {

	public Candidate(String table, String pkey2, List<Match> list, double totalscore) {
		Match[] matches = new Match[list.size()];
		int i=-1;
		for(Match match : list)
			matches[++i]=match;
		this.setAttributeMatches(matches);
		this.setScore(totalscore);
		this.setPkey(pkey2);
		this.setTable(table);
	}
	public void setAttributeMatches(Match[] attributeMatches) {
		this.attributeMatches = attributeMatches;
	}
	public Match[] getAttributeMatches() {
		return attributeMatches;
	}
	public void setScore(double score) {
		this.score = score;
	}
	public double getScore() {
		return score;
	}
	public void setPkey(String pkey) {
		this.pkey = pkey;
	}
	public String getPkey() {
		return pkey;
	}
	public void setTable(String table) {
		this.table = table;
	}
	public String getTable() {
		return table;
	}
	private Match[] attributeMatches;
	private String pkey;
	private double score;
	private String table;
}
