/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.processing;


public class GradientGenerator {
	public static final int MIDDLELOW = 1;
	public static final int ADDRESS = 2;
	public static final int LEFTHIGH = 3;
	public static final int RIGHTHIGH = 4;
	public static int MIDDLEHIGH=5;
	public static int LINEAR=0;

	public static double[] generate(int minwords, int maxwords, double startw, double endw, double resw, int gradient){
		return generate(minwords,maxwords,startw,endw,resw,gradient, false);
	}
	
	public static int getGradient(String type){
		if (type==null)
			return LINEAR;
		if (type.equalsIgnoreCase("LINEAR"))
			return LINEAR;
		if (type.equalsIgnoreCase("ADDRESS"))
			return ADDRESS;
		if (type.equalsIgnoreCase("LEFTHIGH"))
			return LEFTHIGH;
		if (type.equalsIgnoreCase("RIGHTHIGH"))
			return RIGHTHIGH;
		if (type.equalsIgnoreCase("MIDDLEHIGH"))
			return MIDDLEHIGH;
		if (type.equalsIgnoreCase("MIDDLELOW"))
			return MIDDLELOW;
		return LINEAR;
	}

	public static double[] generate(int minwords, int maxwords, double startw, double endw, double resw, int gradient, boolean asContent){
		double[] weights= new double[maxwords];
		if (minwords==0)
			return null;
		minwords=(minwords+maxwords)/2;
		if (gradient==LINEAR){
			double incw=(startw-endw)/(minwords);
			if (incw==0)
				incw=startw/minwords;
			for (int i=0; i<minwords; i++){
				weights[i]=incw;
			}
			if (maxwords-minwords>0) incw=resw/(maxwords-minwords); else incw=resw;
			for (int i=minwords; i<maxwords; i++){
				weights[i]=incw;			
			}				
		}
		else
			if (gradient==LEFTHIGH){
				double incw=((startw-endw)/(minwords-1));
				double lastweight=0;
				for (int i=0; i<minwords; i++){
					weights[i]=startw;
					lastweight=startw;
					startw=startw-incw;
				}
				incw=(resw-lastweight)/(maxwords-minwords);
				//incw=resw;///(maxwords-minwords);			
				for (int i=minwords; i<maxwords; i++){					
					weights[i]=lastweight;
					lastweight+=incw;
				}			
			} else
				if (gradient==RIGHTHIGH){
					double incw=(startw-endw)/(minwords-1);
					for (int i=0; i<minwords; i++){
						weights[i]=startw;
						startw=startw-incw;
					}				
				} else
					if (gradient==MIDDLEHIGH){
						double middle1 = Math.floor((minwords-1)/2);
						int middle2 = (int)middle1;
						if (middle1<(minwords-1)/2.0)
							middle2++;

						for (int i=0; i<=maxwords; i++){
							weights[i]=endw;
						}
						weights[middle2]=startw;
					}  else
						if (gradient==MIDDLELOW){
							for (int i=1; i<maxwords; i++){
								weights[i]=endw;
							}
							weights[0]=startw;
							weights[maxwords-1]=startw;
						} else
							if (gradient==ADDRESS){
								int numendtokens=Math.min(minwords, 5);
								
								startw=startw/numendtokens;
								resw=resw/(maxwords-numendtokens);
								for (int i=0; i<numendtokens; i++){
									weights[i]=startw;
								}
								//override the first 3 tokens and last 2 tokens
								for (int i=numendtokens; i<maxwords; i++)
									weights[i]=resw;
							}
		return weights;
	}

	public static void main(String[] args){
		double[] weights = GradientGenerator.generate(4, 5, 2, 1, 0.2, 0);
		double t=0;
		for (double grad : weights){
			System.out.println(grad);
			t+=grad;
		}
		System.out.println(t);

	}

	public static double sum(double[] gradients) {
		double sum=0;
		if (gradients==null)
			System.out.println("Gradients are null");
		for (double i: gradients)
			sum+=i;
		return sum;
	}
}
