/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.storage;

import java.io.Serializable;
import java.util.Date;

public class Context implements Serializable{
	private String keyname;
	private String value;
	private Date dateOf;
	public Context(String key, String value, Date dateOf) {
		keyname=key;
		this.value=value;
		this.setDateOf(dateOf);
	}
	
	public boolean equals(Context other){
		return (toString().equalsIgnoreCase(other.toString()));
	}
	
	public String toString(){
		return (keyname + ":::" + value).trim();
	}
	
	public String toJSONString(){
		return "\""+keyname + "\": \"" + value + "\"";
	}
	
	public void setKeyname(String document) {
		this.keyname = document;
	}
	public String getKeyname() {
		return keyname;
	}
	public void setValue(String context) {
		this.value = context;
	}
	public String getValue() {
		return value;
	}

	public void setDateOf(Date dateOf) {
		this.dateOf = dateOf;
	}

	public Date getDateOf() {
		return dateOf;
	}

}
