/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.storage;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ContextMap implements Serializable {
	private HashSet<Context> items;
	private String name;
	private boolean internal;
	private ArrayList<Map<String, Object>> values;
	
	SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z '('z')'");

	

	public ContextMap(String relname, boolean internal, Map<String, Object> values){
		name=relname;
		this.internal=internal;
		items = new HashSet<Context>();
		this.values=new ArrayList<Map<String, Object>>();
		this.values.add(values);
		
	}

	public ContextMap(Map<String, Object> values) {	
		this.values=new ArrayList<Map<String, Object>>();
		this.values.add(values);
	}

	public ContextMap(String relname, ArrayList<Map<String, Object>> strContextMap) {
		this.values=strContextMap;
		this.name=relname;
	}

	public String serialize(){
		String res = name + ":::" + internal + "::";
		for (Context ctx : items){
			res = res + ctx.toString() + "\n";
		}
		return res;
	}

	public String valuesToJSONString(){
		StringBuilder sb = new StringBuilder();
		
		sb.append("[");
		if (values!=null){
			
			for (int index =0; index<values.size(); index++){
				sb.append("{\"index\":\""+index+"\"");
			    for (String key : values.get(index).keySet())
			    	if (values.get(index).get(key) instanceof String)
				       sb.append(", \""+key+"\": \""+values.get(index).get(key).toString().replaceAll("\n", "")+"\"");
			    	else if (values.get(index).get(key) instanceof Date)
			    	   sb.append(", \""+key+"\": \""+ sdf.format(((Date)values.get(index).get(key))) +"\"");
			    	else if (values.get(index).get(key) instanceof Number || values.get(index).get(key) instanceof Boolean)
				    	   sb.append(", \""+key+"\": "+ values.get(index).get(key) +"");
				    
			    sb.append("}");
			    if (index<values.size()-1)
			    	sb.append(",");
		    }
			
		}
		sb.append("]");
		return sb.toString();
	}

	

	public boolean addItems(Context item) {
		boolean found=false;
		for (Context context : items){
			if (context.equals(item))
			{
				found=true;
				break;
			}
		}
		if (!found)
			this.items.add(item);
		return !found;
	}

	public HashSet<Context> getItems() {
		return items;
	}

	public void setRelName(String name) {
		this.name = name;
	}

	public String getRelName() {
		return name;
	}

	public boolean hasItems() {
		return items!=null;
	}

	public boolean isInternal() {
		return internal;
	}

	//utility
	public static HashMap<String, Object> createNewMap(String key, Object value) {
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put(key, value);
		return map;
	}

	//just a convient storage
	public void pushProperties(Map<String, Object> props) {
		if (!values.contains(props))
		   this.values.add(props);		
	}

	public Map<String, Object> getProperties(int index){
		return values.get(index);
	}


}
