/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.entitystream.monster.db.Document;
import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.IRelationship;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.match.MatchRecord;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.match.MatchTableInterface;
import com.entitystream.identiza.entity.resolve.match.Token;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.WordList;

public interface RecordInterface extends Comparable{

	INode getBaseNode();

	String getPkey();

	void neverLoad() throws Exception;

	String getTableName();

	void setPkey(String pkey);

	String getEIDField();

	ArrayList<String> getFieldNames() throws Exception;

	void setValue(String colname, Object value);

	String getValue(String colname) throws Exception;

	Map<String, Object> toHashMap() throws Exception;

	String display() throws Exception;

	void setLabelFields(List<String> labelFields);

	List<String> getLabelFields();

	boolean applyInheritanceFrom(RecordInterface targetRec);

	String toString();

	boolean setValues(Document vals);

	Collection<RecordInterface> getHistoryRecords();

	void addHistoryRecord(INode newValues, String action, String username) throws Exception;

	ConcurrentHashMap<String, Object> getValues() throws Exception;

	INode setBaseNode(INode baseNode2);

	Date getLastUpdated();

	void setLastUpdated(Date date) throws Exception;

	List<Standardized> getStandardised(String purposeColumnName, MatchProcInterface proc, List<PurposeColumnMap> map,
			WordList anon) throws Exception;

	List<Standardized> standardise(String purposeName, MatchProcInterface proc, List<PurposeColumnMap> pcm,
			WordList anon) throws Exception;

	Iterable<RecordInterface> getAllRecords();

	MatchRecordInterface calculateScore(RecordInterface comparitor, boolean forSearch, boolean googleSearch, boolean asContent,
			boolean matchScoring) throws Exception;

	String getIcon();

	String getSystemName() throws Exception;

	void setSystemName(String systemName) throws Exception;

	void setUpdatedBy(String updatedBy);

	String getUpdatedBy();

	RecordInterface getDocument();

	static RecordInterface build(MatchSchemaInterface matchSchema) throws Exception{
		return new Record(matchSchema);
	}

	RecordInterface assignNode(INode node) throws Exception;

	RecordInterface assignTable(MatchTableInterface table) throws Exception;

	
	boolean isValid();

	
	void load();

	
	ConcurrentHashMap<INode, ContextMap> getRelatedNodes(String reltype, String direction, Date when) throws Exception;

	
	IRelationship getRelatedTo(RecordInterface recFrom, String reltype, Date when) throws Exception;

	List<Document> getXref();

	
	boolean isInternal();

	
	String getSensitivityValue() throws Exception;

	
	String getAction() throws Exception;

	
	String getKeyField();

	
	boolean isHistory();

	
	RecordInterface save(boolean keyChanged, String username) throws Exception;

	
	boolean isComplete() throws Exception;

	
	boolean isSensitive() throws Exception;

	
	void addRelatedRec(RecordInterface rec2, String reltype, Date date, Document data, String reason,
		String userName) throws Exception;

	
	void saveNoIndexes(String user) throws Exception;

	
	void addRelatedRec(RecordInterface targetRec, String reasonVerb, Date dateOf, String actionThatCausedThis,
		String user) throws Exception;

	
}