/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.storage;

import java.io.Serializable;
import java.util.HashMap;

public class RecordValues implements Serializable{
    /**
	 * 
	 */
	private static final long serialVersionUID = 5350672955340093080L;
	private RecordValue[] values;
	public RecordValues(RecordValue[] recvalues){
		values=recvalues;
	}
    public void setValues(RecordValue[] recvals){
    	values = recvals;
    }
    public RecordValue[] getValues(){
    	return values;
    }

	public HashMap<String, Object> toHashMap() {
		HashMap<String, Object> ret = new HashMap<String, Object>();
    	if (values!=null){
    	  for (int i=0; i<values.length;i++)
    		if (values[i].getKey()!=null && values[i].getValue()!=null)
    		ret.put(values[i].getKey(), values[i].getValue());
    	}
    	return ret;
	}
}
