/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.storage;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.monster.db.Document;

public class Task implements Serializable, Comparable<Task>{
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private String name;
    private Result[] nodes;
    private String table;
    private String id;
    private String type="Duplicate";
    private String resolvedBy;
    private Document workflow;
    private List<String> actions;
    public Task(){

    }
    public Task(String object) {
	this.id=object;
    }
    public String getId(){
	return id;
    }

    public String getName() {
	return name;
    }
    public void setName(String name) {
	this.name = name;
    }
    public Date getCreated() {
	return created;
    }
    public void setCreated(Date created) {
	this.created = created;
    }
    public Date getDue() {
	return due;
    }
    public void setDue(Date due) {
	this.due = due;
    }
    public boolean isResolved() {
	return resolved;
    }
    public void setResolved(boolean resolved) {
	this.resolved = resolved;
    }
    public String getComment() {
	return comment;
    }
    public void setComment(String comment) {
	this.comment = comment;
    }
    public String getStatus(){
	Date today = new Date();
	if (resolved) 
	    return "Resolved";
	else
	    if (due!=null) {
		if (due.after(today))
		    return "Overdue";
		else
		    return "On Time";
	    } else return "Unknown";
    }
    public void setNodes(Result[] nodes) {
	this.nodes = nodes;
    }
    public Result[] getNodes() {
	return nodes;
    }
    public void setTable(String table) {
	this.table = table;
    }
    public String getTable() {
	return table;
    }
    public String getDocumentType() {
	return documentType;
    }
    /**
     * @param object
     */
    public void setResolvedBy(String object) {
	this.resolvedBy=object;

    }

    private Date created;
    private Date due;
    private boolean resolved;
    private String comment;
    private double score;
    private String ruleid;
    private int taskcount;
    private String action;
    private List resolutions;
    private int step;
    private String documentType;
    public void setAction(String action) {
	this.action = action;
    }
    public double getScore() {
	// TODO Auto-generated method stub
	return score;
    }
    public void setScore(double score) {
	// TODO Auto-generated method stub
	this.score=score;
    }
    public String getRule() {
	// TODO Auto-generated method stub
	return ruleid;
    }
    public void setRule(String ruleid){
	this.ruleid=ruleid;
    }
    @Override
    public int compareTo(Task arg0) {
	// TODO Auto-generated method stub
	if (arg0.getScore()<this.getScore())
	    return -1;
	else if (arg0.getScore()>this.getScore())
	    return 1;
	else return 0;
    }
    @Override 
    public boolean equals(Object arg0){
	if (arg0 instanceof Task)
	    return this.id==((Task)arg0).getId();
	else
	    return true;
    }
    public void setCount(int taskcount) {
	this.taskcount=taskcount;

    }

    public int getTaskCount(){
	return taskcount;
    }
    public String getType() {
	return type;
    }
    public void setType(String type) {
	this.type = type;
    }
    public String getAction() {

	return action;
    }

    public static Task build(MatchSchemaInterface schema, Document aTaskNode) {
	if (aTaskNode==null)
	    return null;
	DateFormat df = DateFormat.getDateInstance();
	Task intTask = new Task(aTaskNode.getString("_id"));	
	//get the count
	if (aTaskNode.get("Task")!=null){

	    intTask.setCount(1);
	    intTask.setName((String) aTaskNode.get("Task"));
	    if (aTaskNode.containsKey("Comment"))
		intTask.setComment((String) aTaskNode.get("Comment"));
	    try {
		if (aTaskNode.containsKey("Created"))
		    if (aTaskNode.get("Created") instanceof Date)
			intTask.setCreated((Date)aTaskNode.get("Created"));
		    else
			intTask.setCreated(df.parse((String) aTaskNode.get("Created")));
		if (aTaskNode.containsKey("Due"))
		    if (aTaskNode.get("Due") instanceof Date)
			intTask.setDue((Date)aTaskNode.get("Due"));
		    else
			intTask.setDue(df.parse((String) aTaskNode.get("Due")));

	    } catch (ParseException e) {
	    }
	    if (aTaskNode.containsKey("Resolved"))
		if (aTaskNode.get("Resolved") instanceof String)
		    intTask.setResolved(Boolean.parseBoolean((String)aTaskNode.get("Resolved")));
		else intTask.setResolved((boolean) aTaskNode.get("Resolved"));

	    if (aTaskNode.containsKey("ResolvedBy"))
		if (aTaskNode.get("ResolvedBy") instanceof String)
		    intTask.setResolvedBy(aTaskNode.getString("ResolvedBy"));
	    if (aTaskNode.containsKey("Tablename"))
		intTask.setTable((String) aTaskNode.get("Tablename"));
	    if (aTaskNode.containsKey("Score")) {
		Object score = aTaskNode.get("Score");
		if (score instanceof Number)
		    intTask.setScore(((Number) score).doubleValue());
		else
		    intTask.setScore(Double.parseDouble((String) score));
	    }
	    if (aTaskNode.containsKey("Rule")) {
		try {
		    intTask.setRule(aTaskNode.getString("Rule"));
		} catch (NumberFormatException e) {
		}
	    }
	    if (aTaskNode.containsKey("Type")) {
		intTask.setType((String)aTaskNode.get("Type"));
	    }
	    if (aTaskNode.containsKey("DocumentType")) {
		intTask.setDocumentType((String)aTaskNode.get("DocumentType"));
	    }

	    if (aTaskNode.containsKey("Workflow")) {
		intTask.setWorkflow(aTaskNode.getAsDocument("Workflow"));
		intTask.setStep(aTaskNode.getInteger("Step"));
		if (aTaskNode.containsKey("Resolutions"))
		   intTask.setResolutions(aTaskNode.getList("Resolutions"));
	    }
	    if (aTaskNode.containsKey("Action")) {
		intTask.setAction(aTaskNode.getString("Action"));
	    }
	    if (aTaskNode.containsKey("Actions")) {
		intTask.setActions(aTaskNode.getList("Actions"));
	    }
	    
	    if (aTaskNode.containsKey("Nodes")) {
		try {
		    ArrayList nodeList=(ArrayList) aTaskNode.get("Nodes");
		    Result[] nodes = new Result[nodeList.size()];
		    int count=-1;
		    for (Object node : nodeList){
			if (node instanceof String) {
			    ///need s to use the right table!!!
			    RecordInterface rec=Record.build(schema).assignNode(new Node(schema.getDb(), (String)node));
			    if (rec!=null){
				count++;
				nodes[count]=new Result(rec);
			    }
			} else if (node instanceof Document) {
			    count++;
			    nodes[count]=new Result();
			    nodes[count].setValues((Document)node);
			}
		    }
		    intTask.setNodes(nodes);
		} catch (Exception e) {
		    e.printStackTrace();
		}
	    }

	}
	return intTask;

    }
    /**
     * @param string
     */
    private void setDocumentType(String string) {
	this.documentType=string;
	
    }
    /**
     * @param list
     */
    private void setResolutions(List list) {
	this.resolutions=list;
	
    }
  
    /**
     * @param integer
     */
    private void setStep(int step) {
	this.step=step;
	
    }
    public String getResolvedBy() {
	return resolvedBy;
    }
    public Document getWorkflow() {
	return workflow;
    }
    public void setWorkflow(Document workflow) {
	this.workflow = workflow;
    }
    public List<String> getActions() {
	return actions;
    }
    public void setActions(List<String> actions) {
	this.actions = actions;
    }

    public Document toDocument() {
	
	
	Document result = new Document();
	result.append("id", getId())
	.append("type", getType())
	.append("action", getAction())
	.append("task", WordList.cleanLeaveSpaces(this.getName()))
	.append("status", getStatus())
	.append("due", getDue())
	.append("created", getCreated())
	.append("comment", getComment())
	.append("resolvedBy", getResolvedBy());
	
	if (getRule()!=null) {
	  result.append("score",  getScore());
	  result.append("ruleid", getRule());
	}
	if (getTable()!=null) 
	   result.append("table", getTable());
	
	if (getDocumentType()!=null) 
	    result.append("DocumentType", getDocumentType());
	if (getActions()!=null)
	    result.append("Actions", getActions());
	if (getWorkflow()!=null) {
	    result.append("Workflow",getWorkflow());
	    result.append("Step",getStep());
	    if (getResolutions()!=null)
	       result.append("Resolutions", getResolutions());
	}
	
	
		
	return result;

    }
    /**
     * @return
     */
    private Object getResolutions() {
	return resolutions;
    }
    /**
     * @return
     */
    private int getStep() {
	return step;
    }
}
