/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.util.logging.Logger;

public class MatchBeatCode extends MatchBase implements Serializable{
	Logger logger = Logger.getLogger("com.identiza");

	//	FORMAT is A123A - strip last A if it exists
	/*
	 *        A  refers to the Division
		      A1  is the district
		      A123  is the neighbourhood
		      A123A  is the individual beat within a neighbourhood; there may be one or more beats
	 */
	public MatchBeatCode(String name, int minwidth, int maxwidth) throws Exception{
		super(name,minwidth, maxwidth);
	}

	public MatchBeatCode(String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "BEATCODE");
	}
	public MatchBeatCode(String name){
		super(name);	
	}

	@Override
	public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent){   
		return stdBase.compare(stdComp, getRuleAnon(), getRuleCv(), isSearch, asContent);
	}
	
	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardCode(words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}
	
	@Override
	public String getKey(String word) {
		try{
			if (word.length()==5){
				return word.toUpperCase().substring(0,word.length()-1);
			} else return "";
		} catch (Exception e){
			return "";
		}
	}

}
