/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

import java.util.logging.Logger;

import com.entitystream.identiza.wordlist.WordList;

public class MatchCode extends MatchBase implements Serializable{
	Logger logger = Logger.getLogger("com.identiza");

	public MatchCode(String name, int minwidth, int maxwidth) throws Exception{
		super(name, minwidth, maxwidth);
	}

	public MatchCode(String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "BEATCODE");
	}
	public MatchCode(String name){
		super(name);	
	}

	@Override
	public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent){   
		return stdBase.compare(stdComp, getRuleAnon(), getRuleCv(), isSearch, asContent);
	}
	
	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardCode(words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}
	
	@Override
	public String getKey(String word) {
		try{
			return word.toUpperCase().replaceFirst("^0+(?!$)", ""); //remove leading zeros			
		} catch (Exception e){
			return "";
		}
	}

	@Override
	public Collection<String> getKeys(Object value, boolean batch){
		return getKeys(value, batch, false);
	}

	@Override
	public Collection<String> getKeys(Object value, boolean batch, boolean issearch){
		if (value instanceof String){
			value = new String[]{(String)value};
		}
		StringBuilder sb = new StringBuilder();
		//key is the original word, list of alternate keys
		for (String val : (String[])value){
			sb.append(getKey(val));
		}
		return Collections.singleton(sb.toString());
	}
	
	
	public static void main(String[] args){
		MatchCode mc = new MatchCode ("");
		System.out.println(mc.getKeys(new String[]{"V","0088888","001"}, true, false));
		
	}
}
