/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;

import com.entitystream.identiza.entity.resolve.utils.EditDistance;


public class MatchEditDistanceDate extends MatchBase  implements Serializable{
	EditDistance ed = new EditDistance();
	DateFormat df = DateFormat.getDateInstance();
	Calendar cal = new GregorianCalendar();

	public MatchEditDistanceDate(String name, int minwidth, int maxwidth) throws Exception{
		super(name,minwidth, maxwidth);
	}

	public MatchEditDistanceDate(String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "EDDISTDATE");
	}
	public MatchEditDistanceDate(String name){
		super(name);	
	}
	public void setName(String name){
		this.ruleFunction = name;
	}


	private String sortLetters(String unsorted){	
		char[] content = unsorted.toCharArray();
		java.util.Arrays.sort(content);
		return new String(content);
	}
	
	@Override
	public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent){   
		return stdBase.compare(stdComp, getRuleAnon(), getRuleCv(), isSearch, asContent);
	}
	
	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardDate(words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}

	@Override
	public String getKey(String word) {
		//convert to date
		Date date = null;
		try {
			date = df.parse(word);
		} catch (Exception e) {
			return "";
		}
		cal.setTime(date);
		String year = cal.get(Calendar.YEAR)+"";
		if (year.length()>2)
		   year = year.substring(year.length()-2, year.length());
		int month = (cal.get(Calendar.MONTH) +1);
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if (day>month)
		    word = year+day+month;
		else
			word = year+month+day;
		return word;		
	}
	
	@Override
	public Collection<String> getKeys(Object value, boolean batch){
		if (value instanceof String){
			value = new String[]{(String)value};
		}
		HashSet<String> ret = new HashSet<String>();
		for (String v : (String[])value){
			ret.add(getKey(v));
		}
		return ret;
		
	}
	
	public static void main (String[] args){
		MatchEditDistanceDate date = new MatchEditDistanceDate("");
		ArrayList<String> one = new ArrayList<String>();
		ArrayList<String> two = new ArrayList<String>();
		one.add("1947/11/04");
		two.add("1947/11/04");
		StandardDate date1 = new StandardDate(one.toArray(new String[one.size()]),null,null,1,"");
		StandardDate date2 = new StandardDate(two.toArray(new String[two.size()]),null,null,1,"");
		System.out.println(date.calculateComparisonScore(date1, date2, false, false));
		
	}
}
