/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;

import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.wordlist.RuleSet;

public class MatchEditDistanceString extends MatchBase implements Serializable{
	EditDistance ed = new EditDistance();
	
	public MatchEditDistanceString(String name, int minwidth, int maxwidth) throws Exception{
		super(name, minwidth, maxwidth);
	}
	
	public MatchEditDistanceString (String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "EDDISTSTR");
	}
	public MatchEditDistanceString(String name){
		super(name);	
	}
	
	@Override
	public String getKey(String word) {
		if (word!=null)
		    return word.toUpperCase().trim().replaceAll("[^A-Z0-9]", "");
		else
			return "";
	}

	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardEditDistanceString(words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}
	
	public static void main(String[] args){
		MatchEditDistanceString mc = new MatchEditDistanceString ("");
		mc.setRuleSet(RuleSet.emptyRuleSet());
		System.out.println(mc.getKeys("GOOGLE", false, true));
		
	}
}
