/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public class MatchEmail extends MatchBase implements Serializable{
	
	public MatchEmail(String name, int minwidth, int maxwidth) throws Exception{
		super(name, minwidth, maxwidth);
	}
	
	public MatchEmail (String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "MATCHEMAIL");
	}
	
	public MatchEmail(String name){
		super(name);	
	}
	
	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardString(words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}
	
	@Override
	public Collection<String> getKeys(Object value, boolean batch){
		HashSet<String> ret = new HashSet<String>();
		String email="";
		if (value instanceof String[]){
			for (String l : (String[])value)
				email = email + l + " ";
			email = email.trim().toUpperCase();
		} else 
			email = ((String)value).toUpperCase();
		try {		
			String before="";
			String after="";
			if (email.contains("@")){
				after = email.substring(email.indexOf("@")+1);
				if (after.contains("."))
					after=after.substring(0,after.indexOf("."));
				before = email.substring(0,email.indexOf("@"));			   			   
			} 			
			after = after.replaceAll("\\.|-|_|@", "");
			String[] bits = before.split("\\.|_|-");
			before="";
			if (bits.length>1){
			 for (int t=0; t<bits.length; t++){
				before=before+bits[t].substring(0, 1);
			 }			 
			} else before=bits[0].substring(0, 2);
			ret.add(before+"@"+after);
			
			
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return ret;
		}
		return ret;		
	}
	

	@Override
	public String getKey(String word) {
		return word.toUpperCase().trim().replaceAll("[^A-Z0-9]", "");		
	}
	
	public static void main (String[] args){
		MatchEmail me = new MatchEmail("");
		System.out.println(me.getKeys("robert.haynes@haynes-web.net", true));
	}
}
