/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

import java.util.logging.Logger;

import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.ControlledVocabularyWordList;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;

public class MatchEndAddress extends MatchBase implements Serializable{
	Logger logger = Logger.getLogger("com.identiza");

	public MatchEndAddress(String name, int minwidth, int maxwidth) throws Exception{
		super(name, minwidth, maxwidth);

	}

	public MatchEndAddress(String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "ADDRESS");
	}

	public MatchEndAddress(String name){
		super(name);
	}

	@Override
	public String getKey(String word) {
		try{
			//get the last token and phenetize it
			if (word != null){
				String[] words = WordList.split(word);
				StringBuilder sb = new StringBuilder();
				for (String wordo : words)
					sb.append(NYSIIS.encode(wordo)); 
				return sb.toString();
			}
			return "";
		} catch (Exception e){
			return "";
		}
	}

	@Override
	public Collection<String> getKeys(Object value, boolean batch){
		return getKeys(value, batch, false);
	}

	@Override
	public Collection<String> getKeys(Object value, boolean batch, boolean isSearch){
		//forces reload of cv is the wrong falg is set
		try {
			if (getKeyCv()!=null)
			   getKeyCv().setChildisParent(false);
		} catch (IdentizaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}	
		
		if (value instanceof String){
			value = new String[]{(String)value};
		}
		HashSet<String> keys = new HashSet<String>();
		//key is the original word, list of alternate keys
		StringBuilder phrase=new StringBuilder("");
		for (int j=0; j<((String[])value).length; j++)
			phrase.append(((String[])value)[j]);
		if (getKeyCv()!=null){
			WordObject parents = getKeyCv().getWord(phrase.toString());
			if (parents != null)
				for (String key : parents.getSameParents())
					keys.add(getKey(key));
			if (keys.size()==0)
				keys.add(getKey(phrase.toString()));
		}
		else
			keys.add(getKey(phrase.toString()));				
		return keys;
	}		



	@Override
	public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent){   
		return stdBase.compare(stdComp, getRuleAnon(), getRuleCv(), isSearch, asContent);
	}

	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardEndAddress(words, this.getRuleAnon(), this.getRuleLookup(), gradient, ruleFunction);
	}

	
}
