/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;

public class MatchList extends MatchBase implements Serializable{

	public MatchList(String name, int minwidth, int maxwidth) throws Exception{
		super(name,minwidth, maxwidth);
		partialKeys=false;
	}
	
	public MatchList (String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "MATCHSTR");
		partialKeys=false;
	}
	
	public MatchList(String name){
		super(name);	
		partialKeys=false;
	}

	@Override
	public String getKey(String word) {
		if (word!=null)
		  return word.toUpperCase().trim().replaceAll("[^A-Z0-9]", "");
		else 
		  return "";
	}
	
	@Override
	public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent){   
		return stdBase.compare(stdComp, getRuleAnon(), getRuleCv(), isSearch, asContent);
	}
	
	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardList(words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}

}
