/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;

public class MatchPhonetic extends MatchBase  implements Serializable{
	//DoubleMetaphone dm = new DoubleMetaphone();
	
	public MatchPhonetic(String name, int minwidth, int maxwidth) throws Exception{
		super(name, minwidth, maxwidth);
	}
	
	public MatchPhonetic(String name, int minwidth, int maxwidth, int start, int end,int gradient)  throws Exception{
		super(name, minwidth, maxwidth, "PHONETIC");
		maxScore = MatchProcInterface.MATCH_VCLOSE;
	}
	
	public MatchPhonetic(String name){
		super(name);	
	}
	

	@Override
	public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent){
		return stdBase.compare(stdComp, getRuleAnon(), getRuleCv(), isSearch, asContent);
	}

	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardPhonetic(originalText,words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}
	
	@Override
	public String getKey(String word){
		return NYSIIS.encode(word.toUpperCase().trim().replaceAll("[^A-Z0-9]", ""));
	}
	
	@Override
	public Collection<String> getKeys(Object value, boolean batch){
		if (value instanceof String){
			value = new String[]{(String)value};
		}
		StringBuilder sb = new StringBuilder();
		//key is the original word, list of alternate keys
		for (int j=0; j<((String[])value).length; j++){
			if (((String[])value)[j]!=null) {
				String[] tempwords = WordList.split(((String[])value)[j]);//.split("[.,!?:; ()&-]+\\s*");
				for (int i=0; i<tempwords.length; i++){
					String word = tempwords[i];
					if((getKeyAnon()!=null && getKeyAnon().isUsefulForComparison(word,1)) 
							|| (getKeyAnon()==null && WordList.sisUsefulForComparison(word,1))){
						sb.append(getKey(word));
					}
				}
			}
		}
		ArrayList<String> ret = new ArrayList<String>();
		ret.add(sb.toString());
		return ret;
	}
	
	public static void main(String[] args){
		MatchPhonetic mp = new MatchPhonetic("");
		mp.setRuleSet(RuleSet.emptyRuleSet());
		mp.minWidth=1;
		mp.maxWidth=1;
		System.out.println(mp.getKeys("GOOGLE", false));
		
	}
		
}
