/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import java.util.logging.Logger;

import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;

public class MatchPostCode extends MatchBase implements Serializable{
	Logger logger = Logger.getLogger("com.identiza");
	public MatchPostCode(String name, int minwidth, int maxwidth) throws Exception{
		super(name, minwidth, maxwidth);
	}

	public MatchPostCode(String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "POSTCODE");
	}
	public MatchPostCode(String name){
		super(name);	
	}
	@Override
	public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent){   
		return stdBase.compare(stdComp, getRuleAnon(), getRuleCv(), isSearch, asContent);
	}
	
	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardMisskeyCode(words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}


	@Override
	public String getKey(String word) {
		int diff=maxWidth-minWidth;
		if (!word.equalsIgnoreCase("NULL")){
		StringBuilder sb = new StringBuilder(word.toUpperCase().substring(0,word.length()-diff));
		replaceChars(sb);
		return sb.toString();
		} else return "";
	}

	//we want one key
	@Override
	public Collection<String> getKeys(Object value, boolean batch){
		if (value instanceof String){
			value = new String[]{(String)value};
		}
		Set<String> ret = new HashSet<String>();
		//each string is a completely separate name ie alias
		String fullValue = "";
		for (int j=0; j<((String[])value).length; j++){
			if (((String[])value)[j]!=null)
				fullValue = fullValue + ((String[])value)[j];
		}
		StringBuilder sb= new StringBuilder();
		for (String v :WordList.split(fullValue))
			sb.append(v.trim());
		if (getKeyAnon()==null || !getKeyAnon().inlist(sb.toString()))
		    ret.add(getKey(sb.toString()));	
		if (!isMandatory)
			ret.add("");
		return ret;
	}

	private void replaceChars(StringBuilder key1) {
		//replace K->X M-N 8-B 6-G 1-I L-I 0-O Q-O 5-S V-U Y-U 2-Z
		NYSIIS.replaceAll(key1, " ", "");
		NYSIIS.replaceAll(key1, "K", "X");
		NYSIIS.replaceAll(key1, "M", "N");
		NYSIIS.replaceAll(key1, "8", "B");
		NYSIIS.replaceAll(key1, "6", "G");
		NYSIIS.replaceAll(key1, "1", "I");
		NYSIIS.replaceAll(key1, "L", "I");
		NYSIIS.replaceAll(key1, "0", "O");
		NYSIIS.replaceAll(key1, "5", "S");
		NYSIIS.replaceAll(key1, "V", "U");
		NYSIIS.replaceAll(key1, "Y", "U");
		NYSIIS.replaceAll(key1, "2", "Z");
	}

	public static void main(String[] args){
		MatchPostCode mpc = new MatchPostCode("");
		mpc.maxWidth=4;
		mpc.minWidth=4;
		/*System.out.println(mpc.getKey("NN3 1TJ"));
		System.out.println(mpc.getKey("NN3 1TH"));
		System.out.println(mpc.getKey("MK5 7EW"));
		System.out.println(mpc.getKey("NK57EW"));*/
		System.out.println(mpc.getKey("NULL"));
		System.out.println(mpc.getKey("Killcare 2250"));
		{
		ArrayList<String> aTokens = new ArrayList<String>();
		aTokens.add("2065");
		ArrayList<String> bTokens = new ArrayList<String>();
		bTokens.add("2065");
		mpc.gradient=3;
		//System.out.println(mpc.calculateComparisonScore(aTokens, bTokens, false));
		}
		{
			ArrayList<String> aTokens = new ArrayList<String>();
			aTokens.add("2257");
			ArrayList<String> bTokens = new ArrayList<String>();
			bTokens.add("3343");
			//System.out.println(mpc.calculateComparisonScore(aTokens, bTokens, false));
		}
	}
}