/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

import com.entitystream.identiza.wordlist.RuleFactory;
import com.entitystream.identiza.wordlist.RuleSet;

public class MatchProcDefinition implements Serializable, MatchProcDefinitionInterface{
	private String domainName;
	private String procName;
	private String className;
	private String groupName;
	private int minwidth;
	private int maxwidth;
	private String keyField;
	private String purposeName;
	private RuleSet ruleSet;
	private boolean isMandatory;
	private String instance;
	private HashMap<String,ArrayList<String>> columns;

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getDomainName()
	 */
	@Override
	public String getDomainName() {
		return domainName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setDomainName(java.lang.String)
	 */
	@Override
	public void setDomainName(String columnName) {
		this.domainName = columnName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getProcName()
	 */
	@Override
	public String getProcName() {
		return procName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setProcName(java.lang.String)
	 */
	@Override
	public void setProcName(String procName) {
		this.procName = procName;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getClassName()
	 */
	@Override
	public String getClassName() {
		if (className!=null && !className.equalsIgnoreCase("null") && className.length()!=0)
		  return className;
		else return "MatchString";
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setClassName(java.lang.String)
	 */
	@Override
	public void setClassName(String className) {
		this.className = className;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setMinWidth(int)
	 */
	@Override
	public void setMinWidth(int minwidth) {
		this.minwidth = minwidth;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getMinWidth()
	 */
	@Override
	public int getMinWidth() {
		return minwidth;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setMaxWidth(int)
	 */
	@Override
	public void setMaxWidth(int maxwidth) {
		this.maxwidth = maxwidth;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getMaxWidth()
	 */
	@Override
	public int getMaxWidth() {
		return maxwidth;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setPurposeName(java.lang.String)
	 */
	@Override
	public void setPurposeName(String purposeName) {
		this.purposeName = purposeName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getPurposeName()
	 */
	@Override
	public String getPurposeName(){
		return purposeName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setRuleSet(com.entitystream.identiza.wordlist.RuleSet)
	 */
	@Override
	public void setRuleSet(RuleSet ruleset){
		this.ruleSet=ruleset;
	}


	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getRuleSet()
	 */
	@Override
	public RuleSet getRuleSet(){
		if (ruleSet!=null)
		   return ruleSet;
		else return RuleFactory.getInstance(className);
	}
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setGroupName(java.lang.String)
	 */
	@Override
	public void setGroupName(String groupName) {
         this.groupName=groupName;	
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setIsMandatory(boolean)
	 */
	@Override
	public void setIsMandatory(boolean mandatory) {
		isMandatory=mandatory;		
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getIsMandatory()
	 */
	@Override
	public boolean getIsMandatory(){
		return isMandatory;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#getInstance()
	 */
	@Override
	public String getInstance() {
		return instance;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#setInstance(java.lang.String)
	 */
	@Override
	public void setInstance(String instance){
		this.instance=instance;
	}
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface#build()
	 */
	@Override
	public MatchProcInterface build() throws Exception {
	    String procname = getProcName();
	    MatchBase matchP = null;
	    String defname = getClassName();
	    if (!defname.contains("."))
		defname = "com.entitystream.identiza.entity.resolve.types." + defname;
	    Class clazz = Class.forName(defname);
	    Constructor cons = clazz.getConstructor(String.class,
		    int.class,
		    int.class);
	    matchP = (MatchBase) cons.newInstance(null,
		    getMinWidth(), getMaxWidth());

	    matchP.init(null);
	    matchP.setRuleSet(getRuleSet());

	    matchP.setMandatory(getIsMandatory());

	    return matchP;
	}

}
