/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.entity.resolve.types.Standardized;



public interface MatchProcInterface{
	public static int WIDE=30;
	public static int NARROW=70;
	public static int STANDARD=50;	
	public static int MATCH_EXACT=100;
	public static int MATCH_VCLOSE=90;
	public static int MATCH_CLOSE=80;
	public static int MATCH_MED=50;
	public static int MATCH_FAR=30;
	public static int MATCH_VFAR=10;
	public String getKey(String word);
	public Collection<String> getKeys(Object value, boolean batch, boolean isSearch);
	public Collection<String> getKeys(HashMap<String, String> value, boolean batch);
	
	public void init(String matchProcName);
	public double calculateComparisonScore(Standardized baseIn, Standardized comparitorTokens, boolean isSearch, boolean asContent);
	public WordList getKeyAnon();
	public WordList getKeyCv();
	public WordList getRuleAnon();
	public WordList getRuleCv();
	public void setRuleSet(RuleSet ruleset);
	public int getMinWidth();
	public int getMaxWidth();
	public boolean isTextIndex();
	
	public void setGradient(int gradientType);
	public ArrayList<String> getPurposeKeys(String in);
	public Standardized standardise(String allWords, String[] words);	
	public String sha256(String base);
	public Collection<String> getKeys(Object value, boolean batch);
	public Class<Standardized> getStandardClass();
	void setRuleFunction(String ruleFunction);

}
