/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class MatchTicker extends MatchBase implements Serializable{
	
	public MatchTicker(String name, int minwidth, int maxwidth) throws Exception{
		super(name, minwidth, maxwidth);
		partialKeys=false;
	}
	
	public MatchTicker (String name, int minwidth, int maxwidth, int start, int end,int gradient, String keyField)  throws Exception{
		super(name, minwidth, maxwidth, "MATCHSTR");
		partialKeys=false;
	}
	
	public MatchTicker(String name){
		super(name);	
		partialKeys=false;
	}

	@Override
	public String getKey(String word) {
		if (word!=null){
			String[] words=word.split("\\.");
			if (words.length>0)
				return words[0].toUpperCase().trim().replaceAll("[^A-Z0-9]", "");
			else
				return word.toUpperCase().trim().replaceAll("[^A-Z0-9]", "");		  
		}
		else 
		  return "";
	}
	
	@Override
	public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent){   
		return stdBase.compare(stdComp, getKeyAnon(), getKeyCv(), isSearch, asContent);
	}
	
	@Override
	public Standardized standardise(String originalText, String[] words){
		return new StandardTicker(words, this.getRuleAnon(), this.getRuleLookup(), gradient,ruleFunction);
	}

	@Override
	public Collection<String> getKeys(Object value, boolean batch){
		if (value instanceof String){
			value = new String[]{(String)value};
		}
		HashSet<String> sb = new HashSet<String>();
		//key is the original word, list of alternate keys
		for (int j=0; j<((String[])value).length; j++){
			if (((String[])value)[j]!=null) {
				String[] strings = ((String[])value)[j].split(" ");
				for (String string : strings)
				   sb.add(getKey(string));
			}
		}
		ArrayList<String> ret = new ArrayList<String>();
		ret.add(sb.toString());
		return ret;
	}
	
	public static void main(String[] args){
		MatchTicker date = new MatchTicker("");

		String[] one = new String[]{"GBP.AX"};
		String[] two = new String[]{"ORCL.AX"};
		
		System.out.println(date.getKeys(one, false));

		
	}
}
