/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;

import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;

public class StandardCode extends StandardizedSerialized  {
	public String key;

	
	public StandardCode(){
		
	}
	public StandardCode(String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
	    StringBuilder db=new StringBuilder();
		
		for (String left: this.originalWords)
			if (left!=null)
			   db.append(left.toUpperCase().replaceFirst("^0+(?!$)", ""));
		
		key = db.toString();
			
	}

	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv,
			 boolean isSearch, boolean asContent) {
		try{
			StandardCode othercode=null;
			if (otherstd instanceof StandardCode)
			    othercode = (StandardCode) otherstd;
			else
				othercode = new StandardCode(otherstd.getComparitorWords(), anon,cv,0, "");
			if (key!=null && othercode != null && othercode.key!=null){
				int score=0;
				for (int i=0; i<Math.min(key.length(), othercode.key.length()); i++){
					if (key.charAt(i)==othercode.key.charAt(i)){
						score++;
					} else break;
				}
				return (new Double(100*score/Math.max(key.length(), othercode.key.length()))).intValue();
			} else return 0;
		} catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	}
	
	public static void main(String[] args){
		StandardCode one = new StandardCode(new String[] { "V", "147904", "8" },null,null,0,"");
		StandardCode two = new StandardCode(new String[] {"8147904"},null,null,0,"");
		System.out.println(one.compare(two, null, null, false, false));
		MatchCode mcde = new MatchCode("");
		mcde.setRuleSet(RuleSet.emptyRuleSet());
		System.out.println(mcde.getKeys(new String[]{"V","147904","8"} , true, false));
	}

}
