/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import com.entitystream.identiza.wordlist.WordList;

public class StandardDate extends StandardizedSerialized {
	StringBuilder date=new StringBuilder(); 


	public StandardDate(){
		
	}
	public StandardDate(String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
		if (words.length>0){
			boolean f=true;
			for (String w: words){
				if (!f)
			      date.append("/");
				f=false;
			    date.append(w);
			}
		}
	}

	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv,
			boolean isSearch, boolean asContent) {
		StandardDate otherDate = (StandardDate)otherstd;
		if (date!=null && otherDate.date!=null){
			DateFormat df = DateFormat.getDateInstance();
			//convert to date
			Calendar date1 = null;
			Calendar date2 = null;
			try {
				date1 = Calendar.getInstance();
				date1.setTime(df.parse(date.toString()));
				date2 = Calendar.getInstance();
				date2.setTime(df.parse(otherDate.date.toString()));
			} catch (Exception e) {
				if (date.toString().equalsIgnoreCase(otherDate.date.toString()))
					return 100;
				else return 0;
			}				

			if (date1.equals(date2))
				return 100;
			else {
				int year1=date1.get(Calendar.YEAR);
				int year2=date2.get(Calendar.YEAR);
				int yearScore=0;
				if (year1==year2)
					yearScore=100;
				else if(year1 % 100 == year2 % 100)
					yearScore=100;
				else yearScore = (100-Math.abs(year1-year2));

				if (date1.get(Calendar.MONTH)==date2.get(Calendar.MONTH)){
					if (date1.get(Calendar.DAY_OF_MONTH)==date2.get(Calendar.DAY_OF_MONTH)){
						return yearScore;
					} else {
						//a few days off? 												
						int daydiff=Math.abs(date1.get(Calendar.DAY_OF_MONTH)-date2.get(Calendar.DAY_OF_MONTH));
						if (daydiff<10 && year1 % 100 == year2 % 100)
							return yearScore*(31-daydiff)/31d;
						else if (date1.get(Calendar.DAY_OF_MONTH) % 10 == date2.get(Calendar.DAY_OF_MONTH) % 10 && year1 % 100 == year2 % 100)
							return yearScore*.5;
					}
				} else {
						//swapped day with month
						if (date1.get(Calendar.DAY_OF_MONTH)==date2.get(Calendar.MONTH)+1 &&
								date2.get(Calendar.DAY_OF_MONTH)==date1.get(Calendar.MONTH)+1){
							return yearScore;
						} else {
							//wrong month same day?
							int monthDiff = Math.abs(date1.get(Calendar.MONTH)-date2.get(Calendar.MONTH));
							if (date1.get(Calendar.DAY_OF_MONTH)==date2.get(Calendar.DAY_OF_MONTH) && year1 % 100 == year2 % 100){ 
							   if (monthDiff<2)
								  return Math.round(yearScore*((double)(12-monthDiff)/12d));
							   else
								   if (date1.get(Calendar.MONTH) % 10 == date2.get(Calendar.MONTH) % 10)
									   return yearScore*.5;
							}
						}
				}

				return 0;
			}
		} 
		else return 0;
	}

	public static void main(String[] args){
		System.out.println(new StandardDate(new String[]{"5/1/1909"},null,null,0,"")
		          .compare(new StandardDate(new String[]{"1/5/09"},null,null,0,""), null,null,false, false));
	}
}
