/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import com.entitystream.identiza.wordlist.WordList;

public class StandardDoubleRange extends StandardizedSerialized  {

	public int[] ages;
	

	public StandardDoubleRange(){
		
	}
	public StandardDoubleRange(String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
		if (words.length>0){
			String key1 = words[0];
			
			int[] ages= new int[2];
			String[] agestr = key1.split("\\-");
			int i=0;
			for (String age : agestr){
				try{
					ages[i]=Integer.parseInt(age);
					i++;
				} catch(Exception e){}
			}
		} 
	}
	
	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv,
			 boolean isSearch, boolean asContent) {
		StandardDoubleRange otherdr=(StandardDoubleRange)otherstd;
		if (ages[0]==otherdr.ages[0] && ages[1]==otherdr.ages[1]){
			return MatchProcInterface.MATCH_EXACT;
		} else if (ages[0]==otherdr.ages[0] || ages[1]==otherdr.ages[1]){
			return MatchProcInterface.MATCH_CLOSE;
		} else if (ages[0]>Math.min(otherdr.ages[0], otherdr.ages[1]) && ages[0]<Math.max(otherdr.ages[0], otherdr.ages[1])){
			return MatchProcInterface.MATCH_MED;
		} else if (otherdr.ages[0]>Math.min(ages[0], ages[1]) && otherdr.ages[0]<Math.max(ages[0], ages[1])){
			return MatchProcInterface.MATCH_MED;
		} else return 0;
	}

}
