/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.util.ArrayList;

import com.entitystream.identiza.entity.resolve.processing.GradientGenerator;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.wordlist.WordList;

public class StandardEditDistanceString extends StandardizedSerialized {

	public StandardEditDistanceString(){
		
	}
	public StandardEditDistanceString(String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
	}

	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv,
			boolean isSearch, boolean asContent) {
		StandardEditDistanceString other = (StandardEditDistanceString)otherstd;
		StringBuilder db=new StringBuilder();
		
		for (String left: this.baseTokens)
			if (left!=null)
			   db.append(left);
		
        StringBuilder sdb=new StringBuilder();
		
		for (String left: ((StandardEditDistanceString)otherstd).baseTokens)
			if (left!=null)
			   sdb.append(left);
		
		double edit=EditDistance.getLevenshteinDistanceOfString(db.toString(), sdb.toString());
		double _return=0;

		double divisor=Math.max(db.toString().length(), sdb.toString().length());
		if (originalWords.length==0 || other.originalWords.length==0)
			_return=-1;
		else{
			if (edit<0) edit=0;
			if (divisor>0)
				_return = 100*(divisor-edit)/divisor;
			else
				_return=-1;
		}
		return _return;
	}

	public static void main(String[] args){
		StandardEditDistanceString one = new StandardEditDistanceString(new String[] {"66753"},null,null,0,"");
		StandardEditDistanceString two = new StandardEditDistanceString(new String[] {"0066753"},null,null,0,"");
		System.out.println(one.compare(two, null, null, false, false));
	}
}
