/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;


import com.entitystream.identiza.wordlist.WordList;

public class StandardEndAddress extends StandardizedSerialized  {

	private int gradient;


	public StandardEndAddress(){
		
	}
	public StandardEndAddress(String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
		this.gradient=gradient;
	}

	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv,
			boolean isSearch, boolean asContent) {
		String[] comparitorTokens = ((StandardEndAddress)otherstd).originalWords;
		int ret=0;
		int num=0;
		double best=0;
		//last token has to match
		double fscore =0.0;

		if (comparitorTokens[comparitorTokens.length-1].equalsIgnoreCase(originalWords[originalWords.length-1]))
			fscore=0.7d;
		else if (cv!=null)
			fscore = 0.7d*(1-cv.isStemmed(comparitorTokens[comparitorTokens.length-1], originalWords[originalWords.length-1]));			

		double score=0.0d;
		if (fscore>0.0d){
			
			double grad = 0.3d/originalWords.length;
			for (String token1 : originalWords){
				double thisScore=0.0d;
				best=0.0d;
				for (String token2 : comparitorTokens){
					if (cv!=null)
						thisScore = grad*(cv.isStemmed(token1, token2));
					else
						if (token1.equalsIgnoreCase(token2))
							thisScore = grad*1.0d;
					if (thisScore>best)
						best=thisScore;
				}
				score+=best;	
			}			
			
		}
		return (score+fscore)*100;
	}

	private int intMatch(String key1, String key2) {
		try{
			int score=0;
			for (int i=0; i<Math.min(key1.length(), key2.length()); i++){
				if (key1.charAt(i)==key2.charAt(i)){
					score++;
				} else break;
			}
			return (new Double(100*score/Math.min(key1.length(), key2.length()))).intValue();
		} catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	}

	public static void main(String[] args){

	}
}
