/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;

import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;

public class StandardFormula extends StandardizedSerialized {
	private int gradient;
	public StandardFormula(){

	}
	public StandardFormula(String originalText, String[] words, WordList ruleAnon, WordList ruleLookup, int gradient, String ruleFunction) {
		super(words, ruleAnon, ruleLookup, gradient,""+ruleFunction.hashCode());

		this.gradient=gradient;
		//this is where the formula should run against the baseTokens
		
		ScriptEngine engine=null;
		
		Bindings bindings=null;
			engine = new ScriptEngineManager(null).getEngineByName("nashorn");
			bindings = new SimpleBindings();
			bindings.put( "originalText", originalText );
			bindings.put( "ruleAnon", ruleAnon );
			bindings.put( "ruleLookup", ruleLookup );
			bindings.put( "gradient", gradient );
			bindings.put( "name", ""+ruleFunction.hashCode() );
			bindings.put( "baseTokens", baseTokens );
		
	
			try {
				Object ret = engine.eval(ruleFunction, bindings);
				if (ret!=null){
					if (ret instanceof ArrayList){
						baseTokens=(ArrayList<String>)ret;
					} else if (ret instanceof String){
						baseTokens.clear();
						baseTokens.add((String) ret);
					} else {
						baseTokens.clear();
						baseTokens.add(ret.toString());
					}
				} else baseTokens=null;
			} catch (Exception e){
				System.out.println("Lookup Formula didnt run: " + e.toString());
			}
		


	}

	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
		return 0;
	}
}
