/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import com.entitystream.identiza.wordlist.WordList;

public class StandardHeight extends StandardizedSerialized  {
	private int gradient;
	

		public StandardHeight(){
			
		}
	public StandardHeight(String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
		this.gradient=gradient;
	}

	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv,
			 boolean isSearch, boolean asContent) {
		String[] comparitorTokens = ((StandardHeight)otherstd).originalWords;
		if (originalWords.length>0 && comparitorTokens.length>0){
			String key1 = originalWords[0];
			String key2 = comparitorTokens[0];
			try{
				double k1 = Double.parseDouble(key1);
				double k2 = Double.parseDouble(key2);
				double diff = Math.abs(k1-k2);
				double pcdiff = (diff/Math.min(k1,k2))*100;
				return (new Double(100-pcdiff)).intValue();
			} catch (Exception e){
				return 0;
			}
		} else return 0.0;
	}


}
