/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;

import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;

public class StandardMisskeyCode extends StandardizedSerialized  {
	public String key;
	public int gradient;
	


	public StandardMisskeyCode (){
		
	}
	public StandardMisskeyCode (String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
		if (words.length>0){
			StringBuilder key1 = new StringBuilder();
			for (String base : words)
				key1.append(base);
			replaceChars(key1);
			key=key1.toString();
		}
	}
	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv,
			 boolean isSearch, boolean asContent) {
		StandardMisskeyCode other = (StandardMisskeyCode)otherstd;
		double score = EditDistance.getLevenshteinDistanceOfString(key, other.key);
		double nTokens = 0;
		if (!isSearch)
			nTokens = Math.max(key.length(), other.key.length());
		else
			nTokens = Math.min(key.length(), other.key.length());
		return 100*((nTokens-score)/nTokens);
	}

	private void replaceChars(StringBuilder key1) {
		//replace K->X M-N 8-B 6-G 1-I L-I 0-O Q-O 5-S V-U Y-U 2-Z
		NYSIIS.replaceAll(key1, " ", "");
		NYSIIS.replaceAll(key1, "K", "X");
		NYSIIS.replaceAll(key1, "M", "N");
		NYSIIS.replaceAll(key1, "8", "B");
		NYSIIS.replaceAll(key1, "6", "G");
		NYSIIS.replaceAll(key1, "1", "I");
		NYSIIS.replaceAll(key1, "L", "I");
		NYSIIS.replaceAll(key1, "0", "O");
		NYSIIS.replaceAll(key1, "5", "S");
		NYSIIS.replaceAll(key1, "V", "U");
		NYSIIS.replaceAll(key1, "Y", "U");
		NYSIIS.replaceAll(key1, "2", "Z");
	}
}
