/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;


import com.entitystream.identiza.wordlist.WordList;

public class StandardStemmedWord extends StandardizedSerialized  {
	private int gradient;
	

	public StandardStemmedWord(){
		
	}
	public StandardStemmedWord(String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
		this.gradient=gradient;
	}
	
	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv,
			 boolean isSearch, boolean asContent) {
		double _ret=0;
		StandardStemmedWord other = (StandardStemmedWord)otherstd;
		for (String base :baseTokens){
			if (anon==null || anon.isUsefulForComparison(base,2)){
				for (String comp : other.baseTokens){
					if (anon==null || anon.isUsefulForComparison(comp,2)){
						if (base.equalsIgnoreCase(comp))
							return 100.0;
						double _newret = cv.isStemmed(base, comp);
						if (_newret>_ret)
							_ret=_newret;
					}
				}
			}
		}
		return _ret;
	}

}
