/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.io.Serializable;
import java.util.ArrayList;

import com.entitystream.identiza.wordlist.WordList;

public class StandardTicker extends StandardizedSerialized {


	public StandardTicker(){
		
	}
	public StandardTicker(String[] words, WordList anon, WordList cv, int gradient, String name){
		super(words, anon, cv, gradient,name);
		for (String word : words)
			this.baseTokens.add(word.toUpperCase());
	}

	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
		ArrayList<String> comparitorTokens=((StandardTicker)otherstd).baseTokens;		
		//compare first bit only
		for (String outer : baseTokens){
			for (String inner : comparitorTokens){					
				if (inner.equalsIgnoreCase(outer))
					return 100.0;
				break;
			}
		}
		return 0.0;
	}
	
	
	public static void main(String[] args){
		StandardTicker scn = new StandardTicker(WordList.split("ORCL"),null,null,0,"");
		StandardTicker scn2 = new StandardTicker(WordList.split("ORCL.AX"),null,null,0,"");

		System.out.println(scn.baseTokens);
		System.out.println(scn2.baseTokens);
		System.out.println(scn.compare(scn2, null, null, false, false));

	}

}
