/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.types;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.entitystream.monster.db.Document;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;

public class StandardizedSerialized implements Standardized {

	protected ArrayList<String> baseTokens = new ArrayList<String>();

	protected String[] originalWords;

	public StandardizedSerialized (){

	}

	public StandardizedSerialized (String[] words, WordList anon, WordList cv, int gradient, String ruleFunction){
		//basic action to happen before all classes standardise
		//anon and translate by word
		if (words==null)
			words=new String[]{};
		this.originalWords=words;

		//now all this has happened - do the same for the phrase
		StringBuilder sb = new StringBuilder();
		for (String word : words)
			sb.append(word.toUpperCase()+" ");
		String all=sb.toString().trim();
		boolean tf=false;
		if (!anon.inlist(all)){
			WordObject wo = cv.getWord(all);
			if (wo!=null){
				String trall=wo.getParent();
				if (trall!=null){
					all=trall;
					//its been tf - so chop it up and leave
					tf=true;
				}
			}
		}

		if (!tf){
			sb=new StringBuilder();
			for (String word : words){
				//is anon?
				if(!anon.inlist(word)){
					//translate it
					WordObject wo=cv.getWord(word);
					String trword=null;
					if (wo!=null)
						trword=wo.getParent();
					if (trword!=null){
						tf=true;
						word=trword;
					} else
						word=WordList.Singularize(word);
					//is anon now?
					if(!anon.inlist(word))
						sb.append(word.toUpperCase()+" ");
				}
			}
			all=sb.toString().trim();
		}

		//and now replace the incoming with this shit
		this.baseTokens=new ArrayList<String>();
		for (String s: all.split(" "))
			if (s!=null && s.trim().length()>0){
				this.baseTokens.add(s.toUpperCase());
			}
	}  

	@Override
	public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
		return 0;
	}


	@Override
	public String[] getComparitorWords() {	
		if (originalWords!=null)
			return originalWords;
		else 
			return baseTokens.toArray(new String[baseTokens.size()]);
	}

	@Override
	public String[] getCalculatedWords() {	
		if (baseTokens!=null)
			return baseTokens.toArray(new String[baseTokens.size()]);
		else return null;
	}

	@Override
	public Document toDocument() {
		Document ret = new Document("Class", this.getClass().getName());
		List<Field> fields = new ArrayList<Field>();
		for (Field f : this.getClass().getDeclaredFields())
			fields.add(f);
		for (Field f : this.getClass().getSuperclass().getDeclaredFields())
			fields.add(f);

		for (Field f : fields){
			f.setAccessible(true);
			try {
				if (!Modifier.isStatic(f.getModifiers())){
					if (f.getType().isArray()){
						List<String> list = new ArrayList();
						for (String o : (String[])f.get(this))
							list.add(o);
						ret.append(f.getName(), list);
					}
					else
						ret.append(f.getName(), f.get(this));
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return ret;
	}

	public static Standardized fromDocument(Document from) {
		try{
			String className = (String) from.get("Class");
			Class<Standardized> clazz = (Class<Standardized>) Class.forName(className);
			Standardized std = clazz.newInstance();
			for (String fname : from.keyString()){
				if (!fname.equalsIgnoreCase("Class")){
					try {
						Field f =null;
						try{
							f= clazz.getDeclaredField(fname);
						} catch (java.lang.NoSuchFieldException e){
							try {
								f= clazz.getSuperclass().getDeclaredField(fname);
							} catch (java.lang.NoSuchFieldException e2){

							}
						}
						if(f!=null){
							f.setAccessible(true);
							if ((from.get(fname) instanceof List) && (f.getType().isArray()))
								f.set(std, ((List<String>)from.get(fname)).toArray(new String[((List<String>)from.get(fname)).size()]));
							else {
								if (from!=null) {
									if (f.getGenericType().getTypeName().equalsIgnoreCase("int")) {
										if (from.getInteger(fname)!=null)
										   f.setInt(std, from.getInteger(fname));
										else 
										   f.setInt(std, (int) from.getLong(fname));
									}
									else if (f.getGenericType().getTypeName().equalsIgnoreCase("double") && from.getDouble(fname)!=null)
										f.setDouble(std, from.getDouble(fname));
									else if (f.getGenericType().getTypeName().equalsIgnoreCase("boolean") )
										f.setBoolean(std, from.getBoolean(fname, false));
									else if (f.getGenericType().getTypeName().equalsIgnoreCase("long"))
										f.setLong(std, from.getLong(fname));
									else 
										f.set(std, from.get(fname));
								} 
							}
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
			return std;
		} catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}

	@Override
	public String computeFn() {
		//if the type supports it then compute a return value based on the origanialWords or baseTokens;
		return null;
	}

}
