/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.metadata;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


import com.entitystream.monster.db.Document;

/**
 * @author roberthaynes
 *
 */
public interface IUser {

    Document toDocument();

    boolean checkUser(String _user);

  

    ArrayList<IUser> getTeamUsers();

    void removeUser(String userName);

    String getUserName();

    String getFullName();

    String getEmail();

    String getGroup();
    
    public void resetPassword(String backlink);
   
    public void sendPassword();

   
    boolean isDeactivated();


    void updateAccount(String fullname2, String encPassword, String oldPassword, String email2, boolean isActive);

    Date getExpiry();

    
    String getCurrentToken();

    boolean getTokenExpiryCheck();

    String getRemoteToken();

    void setRemoteToken(String t);

   
    /**
     * @param username2
     * @param fullname2
     * @param email2
     * @param admin
     * @param schema
     * @param isActive
     * @param isLocal
     * @param isLDAP
     * @param groups
     */
    void updateUser(String username2, String fullname2, String email2, boolean admin, boolean schema, boolean isActive,
	    boolean isLocal, boolean isLDAP, List<String> groups);

    /**
     * @return
     */
    List<String> getGroups();

    /**
     * @return
     */
    Document getRights();
    void setRights(Document rights);

    /**
     * @param user
     */
    void updateUser(Document user);

    /**
     * @param token
     * @return
     */
    Document externalAuthenticate(String token);

    /**
     * @return
     */
    List<String> getApplications();

   
    
    
   
    

}