/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.metadata;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import com.entitystream.monster.db.Document;

public class IdentizaSettings {
	public static final String SCHEMANAME = "SchemaName";
	public static final String PROJECTNAME = "ProjectName";
	public static final String GROUPNAME = "groupName";
	public static final String SCHEMATABLE="Schemas";
	public static final String PROJECTTABLE="Projects";
	private static final String MESSAGESTABLE = "Messages";
	private static Logger logger = Logger.getLogger("com.identiza");
	

	
	private static String workingDir;
	
	private static Map<String, Document> schemas = new HashMap<String, Document>();

	public static String getApplicationRootPath(String addpath){
		String path=getWorkingDir();
		path = path.replace("\\", "/").trim();
		if (!path.endsWith("/"))
			path = path + "/";
		path = path + "userdata/";
		if (addpath.startsWith("/") || addpath.indexOf(":")!=-1)
			return addpath;
		else return path + addpath;
	}


	public static void setWorkingDir(String dir) {
		if (dir!=null)
			workingDir=dir;
	}


	private static String getWorkingDir() {
		if (workingDir==null){
			if (System.getenv("dbLoc")!=null)
			    return System.getenv("dbLoc");
			else
			    return System.getProperty("user.home")+"/EntityStream";
		}
		return workingDir;

	}

	public static String getRootPath(String addpath){
		String path=getWorkingDir();
		path = path.replace("\\", "/").trim();
		if (!path.endsWith("/"))
			path = path + "/";
		if (addpath.startsWith("/") || addpath.indexOf(":")!=-1)
			return addpath;
		else return path + addpath;
	}


	public static String getUserRootPath(String string, String groupName) {
		return getApplicationRootPath(groupName) + "/" + string;
	}

	
	public static String getUserTempPath(){
		String path=getWorkingDir();
		path = path.replace("\\", "/").trim();
		if (!path.endsWith("/"))
			path = path + "/";
		path+="tmp/";
		File pathf = new File(path);
		pathf.mkdirs();
		return path;
	}

	

	
}
