/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.metadata;

import java.util.HashMap;
import java.util.Properties;


public interface Project {

		/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#setProjectName(java.lang.String)
	 */
	public abstract void setProjectName(String projectName);

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#getProjectName()
	 */
	public abstract String getProjectName();

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#setCustomMenus(java.util.HashMap)
	 */
	public abstract void setCustomMenus(HashMap<String, Properties> customMenus);

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#getCustomMenus()
	 */
	public abstract HashMap<String, Properties> getCustomMenus();

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#getDBServer()
	 */
	public abstract String getDBServer();

	public abstract String getGroupName();

	public abstract void setGroupName(String groupName);

	public abstract String getOwner();

	public abstract void setOwner(String owner);

	public abstract void setDbServer(String dbServer);

	public abstract String getUserExit();

	public abstract void setUserExit(String userExit);

	public abstract int getDbType();

	public void setDbType(int type);

	public abstract boolean onLoad();

	void setOnLoad(boolean ol);

	com.entitystream.monster.db.Document toDocument();

}