/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import java.util.logging.Logger;

import com.entitystream.monster.db.Document;
import com.entitystream.identiza.db.DBType;


public class ProjectImpl implements Serializable, Project {
	
	private String projectName;
	private String schemaName;
	private String groupName;
	private String owner;
	private HashMap<String, Properties> customMenus = new HashMap<String, Properties>();
	private String dbServer;
	private String userExit;
	//private int dbType;
	private boolean onload;
	private static Logger logger = Logger.getLogger("com.identiza");

	public ProjectImpl(){
		
	}
	public ProjectImpl(String project, String owner, String schemaName, String group, HashMap<String, Properties> customMenus, String url, String userExit, int dbType, boolean onLoad2) {
		this.schemaName = schemaName;
		this.setProjectName(project);
		this.owner = owner;
		this.groupName=group;
		this.userExit=userExit;
		//this.dbType=dbType;
		
		this.onload=onLoad2;
		this.setCustomMenus(customMenus);
		this.setDBServer(url);
	}

	public ProjectImpl(Document document) {
		schemaName=document.getString(IdentizaSettings.SCHEMANAME);
		projectName=document.getString(IdentizaSettings.PROJECTNAME);
		owner=document.getString("owner");
		groupName=document.getString(IdentizaSettings.GROUPNAME);
		userExit=document.getString("userExit");
		//dbType=document.getInteger("dbType");
		if (document.get("customMenus")!=null)
		   setCustomMenus(document.getAsDocument("customMenus"));
		dbServer=document.getString("dbServer");
	}

	@Override
	public Document toDocument(){
		Document document = new Document();
		document.append(IdentizaSettings.SCHEMANAME, schemaName);
		document.append(IdentizaSettings.PROJECTNAME, projectName);
		document.append(IdentizaSettings.GROUPNAME, groupName);
		document.append("owner", owner);
		document.append("userExit", userExit);
		//document.append("dbType", dbType);
		document.append("dbServer", dbServer);
		document.append("customMenus", customMenus);
			
		return document;
	}
	
	private void setCustomMenus(Document document) {
		customMenus = new HashMap<String, Properties>();
		for (String cmname : document.keyString()){
			Properties props = new Properties();
			props.putAll((Map)document.getAsMap(cmname));
			customMenus.put(cmname, props);
		}
		
	}
	private void setDBServer(String url) {
		dbServer=url;
		
	}

		/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#setProjectName(java.lang.String)
	 */
	@Override
	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#getProjectName()
	 */
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#getProjectName()
	 */
	@Override
	public String getProjectName() {
		return projectName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#setCustomMenus(java.util.HashMap)
	 */
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#setCustomMenus(java.util.HashMap)
	 */
	@Override
	public void setCustomMenus(HashMap<String, Properties> customMenus) {
		this.customMenus = customMenus;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#getCustomMenus()
	 */
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#getCustomMenus()
	 */
	@Override
	public HashMap<String, Properties> getCustomMenus() {
		return customMenus;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.ProjectInterface#getDBServer()
	 */
	@Override
	public String getDBServer() {
		// TODO Auto-generated method stub
		return dbServer;
	}

	

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#getGroupName()
	 */
	@Override
	public String getGroupName() {
		return groupName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#setGroupName(java.lang.String)
	 */
	@Override
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#getOwner()
	 */
	@Override
	public String getOwner() {
		return owner;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#setOwner(java.lang.String)
	 */
	@Override
	public void setOwner(String owner) {
		this.owner = owner;
	}


	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.processing.Project#setDbServer(java.lang.String)
	 */
	@Override
	public void setDbServer(String dbServer) {
		this.dbServer = dbServer;
	}

	@Override
	public String getUserExit() {
		return userExit;
	}

	@Override
	public void setUserExit(String userExit) {
		this.userExit=userExit;
	}

	@Override
	public int getDbType() {
	return 1;
	}

	@Override public void setDbType(int type){
		
	}

	@Override
	public boolean onLoad() {
		return this.onload;
	}
	
	@Override 
	public void setOnLoad(boolean ol){
		this.onload=ol;
	}

}
