/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public interface Projects {

	public abstract ArrayList<String> getProjects(
			String groupName);

	public abstract Project getProject(String projectName,
			String groupName);



	public abstract void updateProject(Project proj, String group);

	public abstract void updateProject(String project, String group,
			HashMap<String, Properties> customMenus);

	
	public abstract void removeProject(String projectName,
			String groupName);

	public abstract Object getProjectLock();

	public abstract void setProjectLock(Object projectLock);

	void addProject(String project, String owner,  String group, HashMap<String, Properties> customMenus);

	

}