/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.userexits;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

public class MessageObject implements UserExitObject, Serializable{
	private String queueName;
	private String payload;
	private ConcurrentHashMap<String, Object> vals;
	private String key;
	private String tableName;
	public MessageObject(String queueName, String payload){
		this.queueName=queueName;
		this.payload=payload;
	}
	public String getPayLoad(){
		return payload;
	}
	public String getQueueName(){
		return queueName;
	}
	public ConcurrentHashMap<String, Object> getVals(){
		return vals;
	}
	public String getKey(){
		return key;
	}
	public String getTable() {
		return tableName;
	}
}
