/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.userexits;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

import java.util.logging.Logger;

import com.entitystream.monster.db.Document;

public class UserExitController implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1486171557334566058L;
	
	private static Logger logger = Logger.getLogger("com.identiza");
	
	private String schemaKey;

	private UserExitInterface userExitObject;

	public UserExitController(String schemaName, String projectName, String groupName, String uEDetails) {
		//decode uEDetails
		String uEName=null;
		Properties props = new Properties();
		String[] temp = uEDetails.split(",");
		for (String temp2: temp){
			String[] parts = temp2.split("=");
			if (parts.length==2){
				if (parts[0].equalsIgnoreCase("classname")){
					uEName=parts[1].trim();
				} else {
					//add to properties
					props.put(parts[0].trim(), parts[1].trim());
				}
			}
		}
		//initialise
		UserExitInterface userExit;
		schemaKey=schemaName+":"+projectName+":"+groupName;		
		//find user exit code
		try {
			if (uEName!=null){
				Class<?> clazz =Thread.currentThread().getContextClassLoader().loadClass(uEName);			
				Constructor<?> cons = clazz.getConstructor();
				userExit = (UserExitInterface) cons.newInstance();
				userExit.initialize(schemaName, projectName, groupName, props);
				//userExit must be sent to storage in the schemaMap
				putUserExitObject(userExit);				
			} else schemaKey=null;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
    private UserExitInterface getUserExitObject(){ 
    	return userExitObject;
    }
    
    private void putUserExitObject(UserExitInterface ue){
    	this.userExitObject=ue;
    }
    
	public void callPostMerge(MergeObject mergeObject) {
		//calling post merge
		if (schemaKey!=null){
			logger.info("Post Merge Fired");
			UserExitInterface ue = getUserExitObject();
			ue.postMerge(mergeObject);
			putUserExitObject(ue);	
		}
	}

	public void callPostUpdate(UpdateObject updateObject){
		if (schemaKey!=null){
			logger.info("Post Update Fired");
			UserExitInterface ue = getUserExitObject();
			ue.postUpdate(updateObject);
			putUserExitObject(ue);	
		}
	}


	public void callPreMerge(MergeObject mergeObject){
		if (schemaKey!=null){
			logger.info("Pre Merge Fired");
			UserExitInterface ue = getUserExitObject();
			ue.preMerge(mergeObject);
			putUserExitObject(ue);	
		}
	}

	public Document callPreUpdate(UpdateObject updateObject){
		if (schemaKey!=null){
			logger.info("Pre Update Fired");
			UserExitInterface ue = getUserExitObject();
			Document ret = ue.preUpdate(updateObject);
			putUserExitObject(ue);	
			return ret;
		}	
		else return null;
	}

	public void callPreJob(JobObject jobObject){
		if (schemaKey!=null){
			logger.info("Pre Job Fired");
			UserExitInterface ue = getUserExitObject();
			ue.preJob(jobObject);
			putUserExitObject(ue);	
		}
	}

	public void callPostJob(JobObject jobObject){
		if (schemaKey!=null){
			logger.info("Post Job Fired");
			UserExitInterface ue = getUserExitObject();
			ue.postJob(jobObject);
			putUserExitObject(ue);	
		}
	}

	public void callOnTimer(TimerObject timerObject){
		if (schemaKey!=null){
			UserExitInterface ue = getUserExitObject();
			ue.onTimer(timerObject);
			putUserExitObject(ue);	
		}	
	}

	public HashMap<String, String> callProcessMessage(MessageObject msgObject){
		if (schemaKey!=null){
			logger.info("Process Message Fired");
			UserExitInterface ue = getUserExitObject();
			HashMap<String, String> ret = ue.processMessage(msgObject);
			putUserExitObject(ue);	
			return ret;
		} else return null;
	}

	public String callPreTask(PreTaskObject taskObject) {
		if (schemaKey!=null){
			logger.info("Pre Task Fired");
			UserExitInterface ue = getUserExitObject();
			String ret = ue.preTask(taskObject);
			putUserExitObject(ue);	
			return ret;
		} else return null;
	}

	public void callOnResolveTask(PostTaskObject postTaskObject) {
		if (schemaKey!=null){
			logger.info("resolve task Fired");
			UserExitInterface ue = getUserExitObject();
			ue.onResolveTask(postTaskObject);
			putUserExitObject(ue);	
		}
	}
	
	public HashMap<String, Properties> getCustomMenuItems() {
		if (schemaKey!=null){
			logger.info("get custom menus called");
			UserExitInterface ue = getUserExitObject();
			return ue.getCustomMenuItems();				
		} else return null;
	}
	
	public void callCustomMenu(String menuName, Properties props){
		if (schemaKey!=null){
			logger.info("get custom menus called");
			UserExitInterface ue = getUserExitObject();
			try {
				String method = ue.getCustomMenuItems().get(menuName).getProperty("methodName");
				Method meth = ue.getClass().getMethod(method, Properties.class);
				meth.invoke(ue, props);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				logger.severe(e.toString());
			}				
		}
	}
}
