/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.userexits;

import java.util.HashMap;
import java.util.Properties;

import com.entitystream.monster.db.Document;

public interface UserExitInterface {
	void initialize(String schemaName, String projectName, String groupName, Properties props);
	void postMerge(MergeObject mergeObject);
	void preMerge(MergeObject mergeObject);
	Document preUpdate(UpdateObject updateObject);
	void postUpdate(UpdateObject updateObject);
	void preJob(JobObject jobObject);
	void postJob(JobObject jobObject);
	void onTimer(TimerObject timerObject);
	PostTaskObject onResolveTask(PostTaskObject taskObject);
	HashMap<String, String> processMessage(MessageObject msgObject);
	String preTask(PreTaskObject taskObject);
	HashMap<String, Properties> getCustomMenuItems();
}
