/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.wordlist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import com.entitystream.monster.db.Document;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.entitystream.identiza.metadata.IdentizaSettings;



public class RuleFactory {
	/**
	 * 
	 */
	private static final long serialVersionUID = -6554438074408458768L;
	private static RuleSetMap rulesets = new RuleSetMap();
	private static boolean offline=false;

	public static void setOffline(){
		offline=true;
	}
	public static void setOnline(){
		offline=false;
	}
	public static RuleSet getInstance(String purposeColumnName){
		if (rulesets.containsKey(purposeColumnName))
			return rulesets.get(purposeColumnName);
		RuleSet rules=RuleSet.emptyRuleSet();
		
		rulesets.put(purposeColumnName, rules);
		return rules;
	}


	public static void invalidate(){
		rulesets = new RuleSetMap();
	}

	public static void build(String purposeColumnName, List<com.entitystream.monster.db.Document> list){
		if (rulesets==null)
			invalidate();
		if (!rulesets.containsKey(purposeColumnName))
			rulesets.put(purposeColumnName, RuleSet.createRuleSet(list.iterator()));
		else
			RuleSet.updateRuleSet(rulesets.get(purposeColumnName), list.iterator());
	}

	public static RuleSetMap getRuleSetMap(){
		return rulesets;
	}

	public static void setRuleSetMap(RuleSetMap rsm){
		System.out.println("Initialised " + rsm.size() + " rule sets: " + rsm.keySet().toString());
		rulesets = rsm;
	}

	public static Object executeApiCall(String string){
		try{
			HttpClient hc = new DefaultHttpClient();
			String url="http://online.mdm4free.com/api/1.0/"+string+"?access_token=09a529e8-3cbd-48b9-9de7-87d8f08a3398";
			HttpGet get = new HttpGet(url);
			HttpResponse resp = hc.execute(get);
			if (resp.getStatusLine().getStatusCode()==200){
				HttpEntity entity = resp.getEntity();
				String body = EntityUtils.toString(entity);

				try {
					JsonParser parser = new JsonParser();
					JsonElement element = parser.parse(body);
					Gson gson = new Gson();
					Object ret=null;
					if (element.isJsonArray()){
						ret = new ArrayList<Document>();
						for(JsonElement el : element.getAsJsonArray())
							((ArrayList<Document>)ret).add(Document.parse(gson.toJson(el.getAsJsonObject())));
						return ret;
					} else {
						return Document.parse(gson.toJson(element.getAsJsonObject()));
					}
				} catch (Exception e){
					e.printStackTrace();
				}
			}
		} catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}

	public static void main (String[] args){
		String[] purposes = new String[] {"MatchCompanyName", "MatchPersonName", "MatchCountry"};
		invalidate();
		for (String purpose : purposes){
			ArrayList<Document> elemlist = (ArrayList<Document>)RuleFactory.executeApiCall("rule/"+purpose);
			if (elemlist!=null)
			   build(purpose, elemlist);
		}
		RuleSetMap rsm = getRuleSetMap();
		try{
			FileOutputStream fos = new FileOutputStream ("/Users/roberthaynes/EntityStream/userdata/rules/ruleset.map");
			ObjectOutputStream oos = new ObjectOutputStream(fos);
			oos.writeObject(rsm);
			oos.flush();
			oos.close();
		} catch (Exception e){
			e.printStackTrace();
		}
	}

}
