/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.wordlist;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.entitystream.monster.db.Document;

public class RuleSetMap extends HashMap<String, RuleSet> implements Serializable{

	private static final long serialVersionUID = 4178085864661851225L;

	public RuleSetMap(Map<String, RuleSet> mapin){
		this.putAll(mapin);

	}
	public RuleSetMap(){
		this.clear();

	}

	public Document toDocument(boolean custom){
		Document ret = new Document();
		for (String purpose : keySet()) {
			ret.append(purpose, this.get(purpose).toDocuments(purpose, custom));
		}
		return ret;
	}

	public static RuleSetMap toMap(Document d) {
		RuleSetMap map = new RuleSetMap();
		for (Object purpose : d.keySet()) {
			Object purObject = d.get((String)purpose);
			if (purObject instanceof Document)
			{
				Document purpDoc = ((Document)purObject);
				RuleSet rs = RuleSet.createRuleSet(purpDoc);
			    map.put((String)purpose, rs);
			} else {
				List<Document> purDocs = d.getList((String)purpose);
				RuleSet rs = RuleSet.createRuleSet(purDocs.iterator());
				map.put((String) purpose, rs);
			}
		}
		return map;
	}

	public static RuleSetMap readMap(String schemaDir) {
		RuleSetMap map = new RuleSetMap();
		String mapfile = schemaDir + "/ruleset.map";
		String mapcust = schemaDir + "/ruleset.custom";
		File mapf = new File(mapfile);
		File mapc = new File(mapcust);
		try{
			if (mapf.exists()){
				ObjectInputStream ois = new ObjectInputStream(new FileInputStream(mapf));
				Object o = ois.readObject();
				if (o instanceof RuleSetMap)
					map = (RuleSetMap)o;
				ois.close();
			}

			if (mapc.exists()){
				BufferedReader reader = new BufferedReader(new FileReader(mapc));
				String line =null;
				StringBuilder sb = new StringBuilder();
				while ((line=reader.readLine())!=null)
					sb.append(line);
				reader.close();
				Document rules = Document.parse(sb.toString());
				for (String matchClass : rules.keyString())
					if (matchClass!=null){
						if(rules!= null && rules.get(matchClass)!=null)
							RuleFactory.build(matchClass, (List<Document>)rules.get(matchClass));
					}
			}
		} catch (Exception e){
			e.printStackTrace();
		}
		return map;
	}


	public static void writeMap(String schemaDir, RuleSetMap map) {
		String mapcust = schemaDir + "/ruleset.custom";
		File mapc = new File(mapcust);
		try{
			FileWriter fos = new FileWriter(mapc);
			BufferedWriter bfw = new BufferedWriter(fos);
			bfw.write(map.toDocument(true).toJson());
			bfw.flush();
			bfw.close();

		} catch (Exception e){
			e.printStackTrace();
		}

		String map2 = schemaDir + "/ruleset.map";
		File map2f = new File(map2);
		try{
			FileOutputStream fos = new FileOutputStream(map2f);
			ObjectOutputStream oos = new ObjectOutputStream(fos);
			oos.writeObject(map);
			oos.flush();
			oos.close();

		} catch (Exception e){
			e.printStackTrace();
		}

	}
}
