/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.wordlist;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.entitystream.monster.db.Document;


public class WordObject implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 7418738679398167805L;
	private String word;
	private HashSet<Stringer> parent;
	private String parentLookup;
	private String key; 
	private int weighting;
	private String type;
	private boolean custom;
	public WordObject (String _word, String key, String type){
		this.word=_word;
		this.parent = new HashSet<Stringer>();
		this.type=type;
		this.setString(key);
	}
	public WordObject (String word, String key, String parent, boolean same, String type)
	{
		this(word, key, type);		
		this.parent.add(new Stringer(parent, same));
		this.parentLookup=parent;
	}
	
	public void setWord(String word) {
		this.word = word;
	}
	public String getWord() {
		return word;
	}
	public void addParent(String parent, boolean same) {
		if (parentLookup==null)
			parentLookup=parent;
		if (parent!=null)
		   this.parent.add(new Stringer(parent, same));
	}
	public boolean hasParents(){
		return !parent.isEmpty();
	}
	
	public String getParent() {
		return parentLookup;
	}
	
	public ArrayList<String> getSameParents() {
		ArrayList<String> parentBack = new ArrayList<String>();
		for (Stringer stringer : parent)
			if (stringer.bool)
			   parentBack.add(stringer.string);
		return parentBack;
	}
	
	public Set<String> getDiffParents() {
		HashSet<String> parentBack = new HashSet<String>();
		for (Stringer stringer : parent)
			if (!stringer.bool)
			   parentBack.add(stringer.string);
		return parentBack;
	}
	
	public void setWeighting(int weighting) {
		this.weighting = weighting;
	}
	public int getWeighting() {
		return weighting;
	}
	public void setString(String key) {
		this.key = key;
	}
	public String getString() {
		return key;
	}
	public String getRuleType() {

		return type;
	}
	public Document toDocument(String purpose) {
		Document d = new Document("type", getRuleType());
		d.append("rulePurpose", purpose);
		if (getRuleType().startsWith("T"))
		   d.append("parent", word);
		List<String> listp = new ArrayList<String>();
		if (!getRuleType().startsWith("T"))
			listp.add(word);
		for (Stringer stringer : parent)
			listp.add(stringer.string);
		d.append("items", listp);
		return d;
	}
	public boolean isCustom() {
		
		return custom;
	}
	public void setCustom(boolean custom) {
		this.custom=custom;
		
	}
		
}


