package com.entitystream.monster.db;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.json.XML;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;



import com.entitystream.identiza.db.Node;
import com.entitystream.monster.geo.*;
import com.entitystream.identiza.entity.resolve.metadata.ITable;

public class Document implements Map, Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = -8864859272192654343L;
    Map mapObject;
    public Document(String key, Object value) {
	try {
	    mapObject = new LinkedHashMap();
	    append(key, value);
	} catch (Exception e) {
	    e.printStackTrace();

	}
    }

    public Document() {
	mapObject = new LinkedHashMap();
    }

    public Document(Object object) {
	try {
	    mapObject = new LinkedHashMap();
	    if (object instanceof JsonObject)
		putAll((JsonObject)object);
	    else if (object instanceof Document)
		mapObject = ((Document)object).mapObject;
	    else if (object instanceof Map)
		mapObject = ((Map)object);
	    else if (object instanceof Entry) {
		mapObject.put(((Entry)object).getKey(), ((Entry)object).getValue());
	    }
	    else if (object instanceof String) {
		JsonParser parser = new JsonParser();
		JsonObject json = (JsonObject) parser.parse((String)object);
		putAll(json);
	    } 
	} catch (Exception e) {
	    e.printStackTrace();

	}
    }




    public Document(Map<String, Object> values) {
	try {
	    mapObject = new LinkedHashMap();
	    putAll(values);
	} catch (Exception e) {
	    e.printStackTrace();

	}
    }

    private void writeObject(ObjectOutputStream oos)
	    throws IOException {
	oos.defaultWriteObject();
	oos.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream ois)
	    throws ClassNotFoundException, IOException {
	ois.defaultReadObject();
	String json = (String)ois.readObject();
	JsonParser parser = new JsonParser();
	JsonObject jsono = (JsonObject) parser.parse(json);
	putAll(jsono);

    }


    public static String toISO8601UTC(Date date) {
	if (date!=null){
	    TimeZone tz = TimeZone.getDefault();

	    DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
	    df.setTimeZone(tz);
	    return df.format(date);
	} else return "";
    }


    public static Date fromISO8601UTC(Object dateo) {
	TimeZone tz = TimeZone.getDefault();
	DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
	df.setTimeZone(tz);

	if (dateo instanceof String) {
	    String dateStr=(String)dateo;
	    try {

		return df.parse(dateStr);
	    } catch (Exception e) {
		try {
		    return new Date(Date.parse(dateStr));
		} catch (Exception e2) {
		    System.out.println("Date could not be interpreted: " + dateStr);
		}
	    }
	} else if (dateo instanceof Date)
	    return (Date)dateo;

	return null;
    }

    private static JsonElement toJsonElement(Object value) {
	try {
	    if (value==null)
		return new JsonNull();
	    else {
		if (value instanceof String)
		    return new JsonPrimitive((String)value);
		else if (value instanceof Boolean)
		    return new JsonPrimitive((Boolean)value);
		else if (value instanceof Number)
		    return new JsonPrimitive((Number)value);
		else if (value instanceof Character)
		    return new JsonPrimitive((Character)value);
		else if (value instanceof Date)
		    return new JsonPrimitive(((Date)value).toInstant().getEpochSecond());

		else if (value instanceof List || value instanceof Set) {
		    JsonArray meNewList = new JsonArray();
		    for (Object item : (List)value) {
			meNewList.add(toJsonElement(item));
		    }
		    return meNewList;
		} else if (value instanceof Document ) {
		    JsonObject meNewObject = new JsonObject();
		    for (String key : ((Document)value).keyString()) {
			Object item = ((Document)value).get(key);
			meNewObject.add((String)key, toJsonElement(item));
		    }
		    return meNewObject;
		}  else if (value instanceof Map ) {
		    JsonObject meNewObject = new JsonObject();
		    for (Object key : ((Map)value).keySet()) {
			Object item = ((Map)value).get(key);
			meNewObject.add((String)key, toJsonElement(item));
		    }
		    return meNewObject;
		} else if (value instanceof JsonPrimitive)
		    return (JsonPrimitive)value;

	    }
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
	return new JsonNull();
    }




    public Document append(String key, Object value) {
	try {
	    if (value instanceof JsonElement)
	    {
		if (value instanceof JsonPrimitive) {
		    mapObject.put(key, jsonPrimitiveToObject((JsonPrimitive) value));
		} else if(value instanceof JsonObject){
		    mapObject.put(key, jsonObjectToObject((JsonObject) value));
		} else if(value instanceof JsonArray){
		    mapObject.put(key, jsonObjectToObject((JsonArray) value));
		}
	    } else
		mapObject.put(key, value);
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
	return this;

    }


    public void putAll(JsonObject value) {
	try {
	    if (value!=null) {
		for (Object key : value.keySet()) {
		    Object item = value.get((String) key);
		    append((String)key, item);
		}
	    }
	} catch (Exception e) {
	    e.printStackTrace();

	}
    }

    @Override
    public void putAll(Map value) {
	try {
	    if (value!=null) {
		for (Object key : ((Map)value).keySet()) {
		    Object item = ((Map)value).get(key);
		    if (key instanceof String)
			append((String)key, item);
		    else if (key instanceof byte[])
			append(new String((byte[])key), item);
		}
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }


    @Override
    public boolean containsKey(Object member) {

	return mapObject.containsKey(member);
    }

    public boolean containsProjection(String member) {
	return containsProjection(mapObject, member);

    }

    private boolean containsProjection(Map doc, String member) {
	String[] parts = member.split("\\.",1);
	if (parts.length==0)
	    return false;
	if (parts.length==1)
	    return doc.containsKey(parts[0]);
	if (doc.containsKey(parts[0]))
	    return containsProjection((Map)doc.get(parts[0]), parts[1]);
	else return false;


    }


    public Object getProjection(String member) {
	return getProjection(mapObject, member);
    }

    private Object getProjection(Object doc, String member) {
	String[] parts = member.split("\\.",2);
	if (doc instanceof Map) {
	    if (parts.length==0)
		return null;



	    if (parts.length==1) {
		Object v = ((Map)doc).get(parts[0]);
		return v;
	    }
	    if (((Map)doc).containsKey(parts[0]))
		return getProjection(((Map)doc).get(parts[0]), parts[1]);
	}  else { //list?
	    if (doc instanceof List) {
		try {
		    int pos= Integer.parseInt(parts[0]);
		    Object obj=((List)doc).get(pos);
		    if (parts.length==1)
			if (!(obj instanceof Map))
			    return obj;
			else return new Document(obj);
		    else if (parts.length==2)
			return getProjection(obj, parts[1]);
		} catch (Exception npe) {
		    List out = new ArrayList();
		    for (Object inner : (List)doc) {
			if (inner instanceof Document)
			    out.add(((Document)inner).get(parts[0]));
			else
			    out.add(getProjection(inner, parts[0]));
		    }
		    return out;

		}
	    }
	}
	return null;
    }

    public Object setProjection(String member, Object value) {
	return setProjection(mapObject, member, value);
    }

    public static Object translateJoinMap$(Map objectIn, Document doc) {
	for (Object key: objectIn.keySet()) {
	    Object out=translateJoin$(objectIn.get(key), doc);

	    objectIn.replace(key, out);

	}
	return objectIn;
    }

    public static Object translateJoin$(Object objectIn, Document doc) {
	if (objectIn instanceof Map) 
	    objectIn=translateJoinMap$(new Document(objectIn), doc);
	else if (objectIn instanceof List)
	    objectIn=translateJoinList$((List)objectIn, doc);
	else {
	    //scalar
	    if (objectIn instanceof String 
		    && ((String)objectIn).startsWith("$")) {
		objectIn = translate$(objectIn, doc);

	    } 
	}
	return objectIn;
    }


    private static Object translateJoinList$(List objectIn, Document doc) {
	List out = new ArrayList();
	for (Object item : (List)objectIn) {
	    item=translateJoin$(item, doc);
	    out.add(item);
	}
	return out;
    }



    // process a scalar or document into a value for this document
    //ie { month: { $month: "$date" }, day: { $dayOfMonth: "$date" }, year: { $year: "$date" } }
    //to { "month" : 3, "day" : 15, "year" : 2014 }

    public static Object translate$(Object objectIn, Document doc) {
	return translate$(objectIn, doc, "");
    }
    public static Object translate$(Object objectIn, Document doc, String stage) {
	if (objectIn instanceof String && ((String)objectIn).startsWith("$")) {
	    //function scalar
	    if (((String)objectIn).equalsIgnoreCase("$date"))
		return new Date();
	    if (((String)objectIn).equalsIgnoreCase("$first")) {
		Object l = doc.getProjection(((String)objectIn));
		if (l instanceof List && ((List)l).size()>0)
		    return ((List)l).get(0);
		else return null;
	    }
	    else return doc.getProjection(((String)objectIn).replace("$", ""));
	} else if (objectIn instanceof Document) {

	    //	System.out.println("objectIn:"+objectIn.toString());
	    //	System.out.println("doc:"+doc.toString());

	    //function pair
	    Document objectDoc=(Document)objectIn;
	    Object objectOut=new Document();

	    for (Object k : objectDoc.keySet()) {
		if(k instanceof String && ((String)k).startsWith("$"))
		    objectOut=translateFn$((String)k+stage,objectDoc.get((String)k),doc);
		else {
		    String ks = (String)k;

		    ((Document)objectOut).append(ks,translate$(objectDoc.get(ks), doc,stage));
		    if (ks.contains(".")) {
			//remove the first item before the dot
			String topkey=ks.substring(0,ks.indexOf("."));
			String remkey=ks.substring(ks.indexOf(".")+1);
			if (doc.get(topkey) instanceof Document)
			    ((Document)objectOut).append(topkey, 
				    translate$(objectDoc.get(topkey), doc.getAsDocument(topkey),stage));
			else if (doc.get(topkey) instanceof List) {
			    List oldlist = doc.getList(topkey);
			    List newlist = new ArrayList();
			    for (Object item : oldlist) {
				if (item instanceof Document) {
				    Document newitem = ((Document)item);
				    Document ret = (Document) translate$(new Document(remkey,objectDoc.get(ks)), (Document)item,stage);
				    for (Object k2 : ret.keySet())
					newitem.append((String) k2, ret.get(k2));
				    newlist.add(newitem);
				}
			    }
			    ((Document)objectOut).append(topkey, newlist);

			} else
			    ((Document)objectOut).append(topkey, translate$(objectDoc.get(ks), doc,stage));

		    }

		}

	    }

	    return objectOut;
	} else 
	    return objectIn;
    }

    public static Object translateFn$(String functname, Object object, Document doc) {
	if (functname.equalsIgnoreCase("$exists")) {
	    if (object instanceof Long && ((Long)object)==1)
		return doc!=null && doc.get("value")!=null;
	    else if (object instanceof Long && ((Long)object)==0)
		return doc!=null && doc.get("value")==null;
	}
	if (functname.equalsIgnoreCase("$gt"))
	    return  doc.getDouble("value")>((Number)object).doubleValue();
	if (functname.equalsIgnoreCase("$lt"))
		return  doc.getDouble("value")<((Number)object).doubleValue();
	if (functname.equalsIgnoreCase("$concat")) {
		StringBuilder out= new StringBuilder();
		for (Object v : (List)object) {
		    out.append(translate$(v, doc));
		}
		return  out.toString();
	}
	if (functname.equalsIgnoreCase("$upper")) {
		Object o = translate$(object, doc);
		if (o instanceof String)
		    return ((String)o).toUpperCase();
		else
		    return o;
	    }
	    if (functname.equalsIgnoreCase("$lower")) {
		Object o = translate$(object, doc);
		if (o instanceof String)
		    return ((String)o).toLowerCase();
		else
		    return o;
	    }
	    if (functname.equalsIgnoreCase("$eq")) {
		if (doc.get("value") instanceof Number && object instanceof Number)
		    return  doc.getDouble("value")==((Number)object).doubleValue();
		else if (object instanceof List) {
		    boolean same=false;
		    Object lastO=null;
		    for (Object o2 : (List)object) {
			Object o = translate$(o2, doc);  
			if (lastO !=null) {
			    if (lastO instanceof Number && o instanceof Number)
				same=((Number)lastO).doubleValue()==((Number)o).doubleValue();
			    else
				same=lastO.equals(o);
			}
			lastO=o;
		    }
		    return same;
		} else return (doc.getString("value", "").equals(object));
	    }
	    if (functname.equalsIgnoreCase("$ne")) {
		if (doc.get("value") instanceof Number && object instanceof Number)
		    return  doc.getDouble("value")!=((Number)object).doubleValue();
		else if (object instanceof List) {
		    boolean same=false;
		    Object lastO=null;
		    for (Object o2 : (List)object) {
			Object o = translate$(o2, doc);  
			if (lastO !=null) {
			    if (lastO instanceof Number && o instanceof Number)
				same=((Number)lastO).doubleValue()==((Number)o).doubleValue();
			    else
				same=lastO.equals(o);
			}
			lastO=o;
		    }
		    return !same;
		} else return !(doc.getString("value", "").equals(object));
	    }
	    if (functname.equalsIgnoreCase("$or")) {
		if (object instanceof List) {

		    for (Object o2 : (List)object) {
			Object o = translate$(o2, doc);  
			if (o instanceof Boolean)
			    if((Boolean)o)
				return true;
		    }
		    return false;
		} 
	    }
	    if (functname.equalsIgnoreCase("$and")) {
		if (object instanceof List) {
		    boolean same=true;
		    for (Object o2 : (List)object) {
			Object o = translate$(o2, doc);  
			if (o instanceof Boolean)
			    if(!(Boolean)o)
				same=false;
		    }
		    return same;
		} 
	    }
	    if (functname.equalsIgnoreCase("$count")) {
		Object o = translate$(object, doc);
		if (o instanceof List) {
		    return ((List)o).size();
		} 
		if (o instanceof Map) {
		    return ((Map)o).size();
		} 
	    }

	    if (functname.equalsIgnoreCase("$equalsIgnoreCase")) {
		if (object instanceof List) {
		    boolean same=false;
		    Object lastO=null;
		    for (Object o2 : (List)object) {
			Object o = translate$(o2, doc);
			if (lastO instanceof String && o instanceof String)
			    same=lastO !=null && ((String)lastO).equalsIgnoreCase((String)o);
			lastO=o;
		    }
		    return same;
		} else if (object instanceof String) 
		    return (doc.getString("value", "").equalsIgnoreCase((String)object));
		else return false;
	    }
	    if (functname.equalsIgnoreCase("$contains")) {
		if (object instanceof List) {
		    boolean same=false;
		    Object lastO=null;
		    for (Object o2 : (List)object) {
			Object o = translate$(o2, doc);
			if (lastO instanceof String && o instanceof String)
			    same=lastO !=null && ((String)lastO).contains((String)o);
			lastO=o;
		    }
		    return same;
		} else if (object instanceof String) 
		    return (doc.getString("value", "").contains((String)object));
		else return false;
	    }
	    if (functname.equalsIgnoreCase("$startsWith")) {
		if (object instanceof List) {
		    boolean same=false;
		    Object lastO=null;
		    for (Object o2 : (List)object) {
			Object o = translate$(o2, doc);
			if (lastO instanceof String) {
			    if (o instanceof String) {
				same=lastO !=null && ((String)lastO).startsWith((String)o);
				if (same) break;
			    } else if (o instanceof List) {
				for (Object oo : (List)o) {
				    same=((String)lastO).startsWith((String)oo);
				    if (same) break;
				}
			    }
			} else if (lastO instanceof List) {
			    for (Object lastOO : (List)lastO) {
				if (o instanceof String) {
				    same=lastOO !=null && ((String)lastOO).startsWith((String)o);
				    if (same) break;
				} else if (o instanceof List) {
				    for (Object oo : (List)o) {
					same=((String)lastOO).startsWith((String)oo);
					if (same) break;
				    }
				}	
				if (same) break;
			    }
			}
			lastO=o;
			if (same) break;
		    }
		    return same;
		} else if (object instanceof String) 
		    return (doc.getString("value", "").startsWith((String)object));
		else return false;
	    }
	    if (functname.equalsIgnoreCase("$endsWith")) {
		if (object instanceof List) {
		    boolean same=false;
		    Object lastO=null;
		    for (Object o2 : (List)object) {
			Object o = translate$(o2, doc);
			if (lastO instanceof String) {
			    if (o instanceof String) {
				same=lastO !=null && ((String)lastO).endsWith((String)o);
				if (same) break;
			    } else if (o instanceof List) {
				for (Object oo : (List)o) {
				    same=((String)lastO).endsWith((String)oo);
				    if (same) break;
				}
			    }
			} else if (lastO instanceof List) {
			    for (Object lastOO : (List)lastO) {
				if (o instanceof String) {
				    same=lastOO !=null && ((String)lastOO).endsWith((String)o);
				    if (same) break;
				} else if (o instanceof List) {
				    for (Object oo : (List)o) {
					same=((String)lastOO).endsWith((String)oo);
					if (same) break;
				    }
				}	
				if (same) break;
			    }
			}
			lastO=o;
			if (same) break;
		    }
		    return same;
		} else if (object instanceof String) 
		    return (doc.getString("value", "").endsWith((String)object));
		else return false;
	    }
	    if (functname.equalsIgnoreCase("$daysBetween")) {
		List items = (List)object;
		Date diff=null;
		Date d=null;
		for (Object item : items) {
		    d=Document.fromISO8601UTC(translate$(item, doc));
		    if (diff==null)
			diff=d;
		    else {
			if (diff.before(d)) 
			  return diff.toInstant().until(d.toInstant(), ChronoUnit.DAYS);
			else
			    return d.toInstant().until(diff.toInstant(), ChronoUnit.DAYS);
		    }
		}
		return 0;
	    }
	    if (functname.equalsIgnoreCase("$monthsBetween")) {
		List items = (List)object;
		Date diff=null;
		Date d=null;
		for (Object item : items) {
		    d=Document.fromISO8601UTC(translate$(item, doc));
		    if (diff==null)
			diff=d;
		    else {
			if (diff.before(d)) 
			  return diff.toInstant().until(d.toInstant(), ChronoUnit.MONTHS);
			else
			    return d.toInstant().until(diff.toInstant(), ChronoUnit.MONTHS);
		    }
		}
		return 0;
	    }
	    if (functname.equalsIgnoreCase("$yearsBetween")) {
		List items = (List)object;
		Date diff=null;
		Date d=null;
		for (Object item : items) {
		    d=Document.fromISO8601UTC(translate$(item, doc));
		    if (diff==null)
			diff=d;
		    else {
			if (diff.before(d)) 
			  return diff.toInstant().until(d.toInstant(), ChronoUnit.YEARS);
			else
			    return d.toInstant().until(diff.toInstant(), ChronoUnit.YEARS);
		    }
		}
		return 0;
	    }
	    if (functname.equalsIgnoreCase("$hoursBetween")) {
		List items = (List)object;
		Date diff=null;
		Date d=null;
		for (Object item : items) {
		    d=Document.fromISO8601UTC(translate$(item, doc));
		    if (diff==null)
			diff=d;
		    else {
			if (diff.before(d)) 
			  return diff.toInstant().until(d.toInstant(), ChronoUnit.HOURS);
			else
			    return d.toInstant().until(diff.toInstant(), ChronoUnit.HOURS);
		    }
		}
		return 0;
	    }
	    if (functname.equalsIgnoreCase("$minutesBetween")) {
		List items = (List)object;
		Date diff=null;
		Date d=null;
		for (Object item : items) {
		    d=Document.fromISO8601UTC(translate$(item, doc));
		    if (diff==null)
			diff=d;
		    else {
			if (diff.before(d)) 
			  return diff.toInstant().until(d.toInstant(), ChronoUnit.MINUTES);
			else
			    return d.toInstant().until(diff.toInstant(), ChronoUnit.MINUTES);
		    }
		}
		return 0;
	    }
	    if (functname.equalsIgnoreCase("$secondsBetween")) {
		List items = (List)object;
		Date diff=null;
		Date d=null;
		for (Object item : items) {
		    d=Document.fromISO8601UTC(translate$(item, doc));
		    if (diff==null)
			diff=d;
		    else {
			if (diff.before(d)) 
			  return diff.toInstant().until(d.toInstant(), ChronoUnit.SECONDS);
			else
			    return d.toInstant().until(diff.toInstant(), ChronoUnit.SECONDS);
		    }
		}
		return 0;
	    }
	    
	    
	    
	    if (functname.equalsIgnoreCase("$month"))
		return (Document.fromISO8601UTC(translate$(object, doc))).getMonth()+1;	
	    if (functname.equalsIgnoreCase("$year"))
		return (Document.fromISO8601UTC(translate$(object, doc))).getYear()+1900;
	    if (functname.equalsIgnoreCase("$dayOfMonth"))
		return (Document.fromISO8601UTC(translate$(object, doc))).getDate();
	    if (functname.equalsIgnoreCase("$pattern"))
		return  doc.getDouble("value")==((Number)object).doubleValue();
	    if (functname.equalsIgnoreCase("$geoWithin")){
		//geoloc wil be in value of doc
		GeoType pg = GeoType.fromDoc((Document)object);
		//actual polygon with be in doc
		GeoType pt= GeoType.fromDoc(doc.getAsDocument("value"));
		//check..
		if (pg!=null && pt != null)
		    return pg.checkInside(pt);
		else
		    return false;
	    }
	    if (functname.equalsIgnoreCase("$multiply")) {
		//object is the list of field name to multiply ie [ "$price", "$quantity" ] 
		List items = (List)object;
		Double multiply=null;
		for (Object item : items) {
		    Double d = Document.toDouble(translate$(item, doc));
		    if (multiply==null)
			multiply=d;
		    else
			multiply=multiply*d;
		}

		return multiply;
	    }
	    if (functname.equalsIgnoreCase("$divide")) {
		//object is the list of field name to multiply ie [ "$price", "$quantity" ] 
		List items = (List)object;
		Double divide=null;
		for (Object item : items) {
		    Double d = Document.toDouble(translate$(item, doc));
		    if (divide==null)
			divide=d;
		    else
			divide=divide/d;
		}

		return divide;
	    }


	    if (functname.equalsIgnoreCase("$push")) {
		Object value = translate$(object, doc);
		return value;
	    }
	    if (functname.equalsIgnoreCase("$pushMap")) {
		//object is additive object ie a number
		//doc is the current document representing the field ie {sum : 123}
		//merge two records that were produced by $sum
		if (doc==null)
		    doc=new Document();
		List list = doc.getList("push");
		if (list==null)
		    list=new ArrayList();
		list.add(object);
		doc.append("push", list);
		return doc;
	    }
	    if (functname.equalsIgnoreCase("$pushFinalize")) {
		//object is the agg definition (we dont care about this)
		//doc is the current document representing the field ie {sum : 123}
		//use the merged values to create a single scalar of the same name

		if (doc!=null)
		    return doc.getList("push");
		else return new ArrayList();
	    }

	    //aggregation functions follow
	    //sum
	    if (functname.equalsIgnoreCase("$sum")) {
		//object is function definition ie { $multiply: [ "$price", "$quantity" ] } or "$price"
		//calculate the value to be aggregated for this record alone
		Object value = translate$(object, doc);
		return value;
	    }

	    if (functname.equalsIgnoreCase("$sumMap")) {
		//object is additive object ie a number
		//doc is the current document representing the field ie {sum : 123}
		//merge two records that were produced by $sum
		Double additive = Document.toDouble(object);
		if (doc==null)
		    doc=new Document();
		Double curr=doc.getDouble("sum");
		if (curr==null)
		    curr=0d;
		curr = curr.doubleValue() + additive.doubleValue();
		doc.append("sum", curr);
		return doc;
	    }
	    if (functname.equalsIgnoreCase("$sumFinalize")) {
		//object is the agg definition (we dont care about this)
		//doc is the current document representing the field ie {sum : 123}
		//use the merged values to create a single scalar of the same name

		if (doc!=null)
		    return doc.getDouble("sum");
		else return 0;
	    }
	    //avg
	    if (functname.equalsIgnoreCase("$avg")) {
		//object is function definition ie { $multiply: [ "$price", "$quantity" ] } or "$price"
		//calculate the value to be aggregated for this record alone
		Object value = translate$(object, doc);
		return value;
	    }

	    if (functname.equalsIgnoreCase("$avgMap")) {
		//object is additive object ie a number
		//doc is the current document representing the field ie {sum : 123, count: 1}
		//merge two records that were produced by $sum
		Double additive = Document.toDouble(object);
		if (doc==null)
		    doc=new Document();
		//sum record
		Double curr=doc.getDouble("sum");
		if (curr==null)
		    curr=0d;
		curr = curr.doubleValue() + additive.doubleValue();
		doc.append("sum", curr);
		//count
		Integer count=doc.getInteger("count");
		if (count==null)
		    count=0;
		count++;
		doc.append("count", count);
		return doc;
	    }
	    if (functname.equalsIgnoreCase("$avgFinalize")) {
		//object is the agg definition (we dont care about this)
		//doc is the current document representing the field ie {sum : 123, count: 1}
		//use the merged values to create a single scalar of the same name

		if (doc!=null) {
		    return doc.getDouble("sum") / doc.getInteger("count", 1); //using 1 default avoids D/Zero
		}
		else return 0;
	    }
	    //max
	    if (functname.equalsIgnoreCase("$max")) {
		//object is function definition ie { $multiply: [ "$price", "$quantity" ] } or "$price"
		//calculate the value to be aggregated for this record alone
		Object value = translate$(object, doc);
		return value;
	    }

	    if (functname.equalsIgnoreCase("$maxMap")) {
		//object is additive object ie a number
		//doc is the current document representing the field ie {min : 123}
		//merge two records that were produced by $sum
		Double additive = Document.toDouble(object);
		if (doc==null)
		    doc=new Document();
		//sum record
		Double curr=doc.getDouble("max");
		if (curr==null)
		    curr=Double.MIN_VALUE;
		curr = Math.max(curr.doubleValue(), additive.doubleValue());
		doc.append("max", curr);
		return doc;
	    }
	    if (functname.equalsIgnoreCase("$maxFinalize")) {
		//object is the agg definition (we dont care about this)
		//doc is the current document representing the field ie {min : 123}
		//use the merged values to create a single scalar of the same name

		if (doc!=null) {
		    return doc.getDouble("max");
		}
		else return 0;
	    }
	    //min
	    if (functname.equalsIgnoreCase("$min")) {
		//object is function definition ie { $multiply: [ "$price", "$quantity" ] } or "$price"
		//calculate the value to be aggregated for this record alone
		Object value = translate$(object, doc);
		return value;
	    }

	    if (functname.equalsIgnoreCase("$minMap")) {
		//object is additive object ie a number
		//doc is the current document representing the field ie {min : 123}
		//merge two records that were produced by $sum
		Double additive = Document.toDouble(object);
		if (doc==null)
		    doc=new Document();
		//sum record
		Double curr=doc.getDouble("min");
		if (curr==null)
		    curr=Double.MAX_VALUE;
		curr = Math.min(curr.doubleValue(), additive.doubleValue());
		doc.append("min", curr);
		return doc;
	    }
	    if (functname.equalsIgnoreCase("$minFinalize")) {
		//object is the agg definition (we dont care about this)
		//doc is the current document representing the field ie {min : 123}
		//use the merged values to create a single scalar of the same name

		if (doc!=null) {
		    return doc.getDouble("min");
		}
		else return 0;
	    }
	    //first
	    if (functname.equalsIgnoreCase("$popFirst")) {
		//object is function definition ie { $multiply: [ "$price", "$quantity" ] } or "$price"
		//calculate the value to be aggregated for this record alone
		Object l = translate$(object, doc);

		if (l instanceof List && ((List)l).size()>0)
		    return ((List)l).get(0);
		return l;
	    }
	    if (functname.equalsIgnoreCase("$popLast")) {
		//object is function definition ie { $multiply: [ "$price", "$quantity" ] } or "$price"
		//calculate the value to be aggregated for this record alone
		Object l = translate$(object, doc);

		if (l instanceof List && ((List)l).size()>0)
		    return ((List)l).get(((List)l).size()-1);
		return l;
	    }
	    if (functname.equalsIgnoreCase("$first")) {
		//object is function definition ie { $multiply: [ "$price", "$quantity" ] } or "$price"
		//calculate the value to be aggregated for this record alone
		Object value = translate$(object, doc);
		return value;
	    }
	    if (functname.equalsIgnoreCase("$firstMap")) {
		//object is additive object ie a number or text
		//doc is the current document representing the field ie {first : 123} or null
		//return the doc if its non null and create a new one if it is
		if (doc==null)
		    doc=new Document("first", object);
		return doc;
	    }
	    if (functname.equalsIgnoreCase("$firstFinalize")) {
		if (doc!=null) {
		    return doc.get("first");
		}
		else return null;
	    }
	    //first
	    if (functname.equalsIgnoreCase("$last")) {
		//object is function definition ie { $multiply: [ "$price", "$quantity" ] } or "$price"
		//calculate the value to be aggregated for this record alone
		Object value = translate$(object, doc);
		return value;
	    }

	    if (functname.equalsIgnoreCase("$lastMap")) {
		//object is additive object ie a number or text
		//we dont care about the doc as we are always going to overrite it
		//return the object always
		doc=new Document("last", object);
		return doc;
	    }
	    if (functname.equalsIgnoreCase("$lastFinalize")) {
		if (doc!=null) {
		    return doc.get("last");
		}
		else return null;
	    }

	    return object;
    }



    public List getList(String member) {
	Object item = mapObject.get(member);
	if (item != null) {
	    if (item instanceof List) {
		return (List)item;
	    } else return Collections.singletonList(item);
	} 
	return new ArrayList();

    }

    private static Double toDouble(Object object) {
	try {
	    if (object instanceof Double)
		return (Double)object;
	    if (object instanceof Integer)
		return ((Integer)object).doubleValue();
	    if (object instanceof Long)
		return ((Long)object).doubleValue();
	    if (object instanceof Float)
		return ((Float)object).doubleValue();
	    if (object instanceof Number)
		return ((Number)object).doubleValue();
	    if (object instanceof String)
		return Double.parseDouble((String) object);
	    if (object instanceof List) {
		for (Object item : (List)object) {
		    return toDouble(item);
		}
	    }
	} catch (Exception e) {

	} 
	return 0d;
    }

    private static Number toNumber(Object object) {
	try {
	    if (object instanceof Number)
		return (Number)object;
	    if (object instanceof String)
		return NumberFormat.getInstance().parse((String) object);
	} catch (Exception e) {

	} 
	return 0;
    }

    private Object setProjection(Object doc, String member, Object value) {
	String[] parts = member.split("\\.",2);
	if (doc instanceof Map) {
	    if (parts.length==0)
		return null;
	    if (parts.length==1)
		return ((Map)doc).put(parts[0],value);
	    if (((Map)doc).containsKey(parts[0]))
		return setProjection(((Map)doc).get(parts[0]), parts[1], value);
	}
	else { //list?
	    if (doc instanceof List) {
		try {
		    int pos= Integer.parseInt(parts[0]);
		    if (pos<((List)doc).size()) {
			Object obj=((List)doc).get(pos);
			return setProjection(obj, parts[1], value);
		    } else {
			if (parts.length==1)
			    ((List)doc).add(pos, value);

		    }
		} catch (Exception npe) {}
	    }
	}
	return false;
    }


    public String getString(String member) {
	try {
	    if (mapObject.containsKey(member) && mapObject.get(member)!=null )
		if (mapObject.get(member) instanceof String)
		    return (String) mapObject.get(member);
		else 
		    return mapObject.get(member).toString();
	    else return null;
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    @Override
    public Object get(Object member) {
	try {
	    if (mapObject.containsKey((String)member) && mapObject.get((String) member)!=null) {
		if (mapObject.get((String)member) instanceof Map)
		    return new Document(mapObject.get((String)member));
		if (mapObject.get((String)member) instanceof List) {
		    List newList = new ArrayList();
		    for (Object item : (List)mapObject.get((String)member)) {
			if (item instanceof Map)
			    newList.add(new Document(item));
			else
			    newList.add(item);
		    }
		    return newList;
		}
		return mapObject.get((String)member);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
	return null;
    }

    public int getInteger(String member, int defaultValue) {
	try {
	    if (mapObject.containsKey(member) && mapObject.get(member)!=null) {
		if (mapObject.get(member) instanceof Integer)
		    return ((Integer) mapObject.get(member)).intValue();
		if (mapObject.get(member) instanceof Long)
		    return ((Long) mapObject.get(member)).intValue();
		else if (mapObject.get(member) instanceof Double)
		    return ((Double) mapObject.get(member)).intValue();
		else if (mapObject.get(member) instanceof String)
		    return Integer.parseInt(((String) mapObject.get(member)));
		else
		    return defaultValue;
	    }
	    else return defaultValue;
	} catch (Exception e) {
	    e.printStackTrace();
	    return defaultValue;
	}
    }

    public Date getDate(String member) {
	if (mapObject.containsKey(member) && mapObject.get(member)!=null) {
	    Object d = mapObject.get(member);
	    if (d instanceof String)
		return (Date)(Document.fromISO8601UTC((String)d));
	    else if (d instanceof Date)
		return (Date) d;
	    else if (d instanceof Long)
		return (Date.from(Instant.ofEpochMilli((long)d)));
	    else return null;
	}
	else return null;
    }

    public long getLong(String member) {
	if (mapObject.containsKey(member) && mapObject.get(member)!=null) {
	    if (mapObject.get(member) instanceof Double)
		return ((Double) mapObject.get(member)).longValue();
	    else if (mapObject.get(member) instanceof Long)
		return ((Long) mapObject.get(member)).longValue();
	    else if (mapObject.get(member) instanceof Integer)
		return ((Integer) mapObject.get(member)).longValue();
	    else if (mapObject.get(member) instanceof String)
	    {
		String s = (String) mapObject.get(member);
		try {
		    return Long.parseLong((s));
		} catch (Exception e) {
		    Pattern p = Pattern.compile("\\d+");
		    Matcher m = p.matcher(s);
		    if(m.find()) {
			return Long.parseLong(m.group());
		    } else return -1;
		}
	    }
	    else
		return -1;
	}
	else return -1;
    }


    public Integer getInteger(String member) {
	if (mapObject.containsKey(member) && mapObject.get(member)!=null) {
	    if (mapObject.get(member) instanceof Integer)
		return ((Integer) mapObject.get(member)).intValue();
	    if (mapObject.get(member) instanceof Long)
		return ((Long) mapObject.get(member)).intValue();
	    else if (mapObject.get(member) instanceof Double)
		return ((Double) mapObject.get(member)).intValue();
	    else if (mapObject.get(member) instanceof String)
		return Integer.parseInt(((String) mapObject.get(member)));
	    else
		return null;
	}
	else return null;
    }

    public Double getDouble(String member) {
	if (mapObject.containsKey(member) && mapObject.get(member)!=null)
	    if (mapObject.get(member) instanceof Double)
		return ((Double) mapObject.get(member)).doubleValue();
	if (mapObject.get(member) instanceof Number)
	    return ((Number)mapObject.get(member)).doubleValue();
	else return null;
    }


    public boolean getBoolean(String member, boolean defaultValue) {
	if (mapObject.containsKey(member) && mapObject.get(member)!=null) {
	    if (mapObject.get(member) instanceof Boolean)
		return (boolean) mapObject.get(member);
	    else if (mapObject.get(member) instanceof String)
		return Boolean.parseBoolean((String)mapObject.get(member));
	    else return defaultValue;
	}
	else return defaultValue;
    }

    public Map getAsMap(String member) {
	try {

	    if (mapObject.containsKey(member) && mapObject.get(member)!=null)
	    { 
		if (mapObject.get(member) instanceof Map)	
		    return (Map) mapObject.get(member);

	    }
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
	return null;
    }

    public Document getAsDocument(String member) {
	try {

	    if (mapObject.containsKey(member) && mapObject.get(member)!=null)
	    { 
		if (mapObject.get(member) instanceof Map) {
		    return new Document((Map)mapObject.get(member));
		}
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
	return null;

    }

    private Object jsonPrimitiveToObject(JsonPrimitive jo) {
	try {
	    if(jo.isString())
		return jo.getAsString();
	    else if(jo.isBoolean())
		return jo.getAsBoolean();
	    else if(jo.isNumber()) {
		Number num = jo.getAsNumber();

		if(jo.getAsString().indexOf(".")==-1 && (Math.ceil(num.doubleValue())  == num.longValue()))
		    return num.longValue();
		else{
		    return num.doubleValue();
		}
	    }
	    return jo;
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    //deep copy
    private Object jsonObjectToObject(JsonElement jo) {
	try {
	    if (jo.isJsonNull())
		return null;
	    else if (jo.isJsonArray()) {
		List meNewList = new ArrayList();
		for (JsonElement item : jo.getAsJsonArray()) {
		    meNewList.add(jsonObjectToObject(item));
		}
		return meNewList;
	    }
	    else if (jo.isJsonObject()) {
		if (((JsonObject)jo).has("pattern")){
		    int flags = 0;
		    if (((JsonObject)jo).has("flags")){
			flags = ((JsonObject)jo).get("flags").getAsInt();
			return Pattern.compile(((JsonObject)jo).get("pattern").getAsString(), flags);
		    }
		} else {
		    Map map = new LinkedHashMap();


		    for (String key : ((JsonObject)jo).keySet()) {
			map.put(key, jsonObjectToObject(((JsonObject)jo).get(key)));
		    }
		    return map;
		}
	    }
	    else if (jo.isJsonPrimitive())
		return jsonPrimitiveToObject(jo.getAsJsonPrimitive());
	    return jo;
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    public static Document toDocument(ITable table) {
	try {
	    Gson gson = new Gson();
	    String json = gson.toJson(table, table.getClass());
	    JsonParser parser = new JsonParser();
	    JsonObject element = (JsonObject) parser.parse(json);
	    return new Document(element);
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    public Map toMap() {

	return mapObject;
    }

    public static Object toObject(Document document, Class<?> type) {
	try {
	    if (document==null || document.toJson()==null)
		try {
		    return type.newInstance();
		} catch (Exception e) {
		    e.printStackTrace();
		}
	    Gson gson = new Gson();
	    Object object = gson.fromJson(document.toJson(), type);
	    return object;
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    public <T> T toObject(Class<T> type) {
	try {
	    Gson gson = new Gson();
	    Object object = gson.fromJson(toJson(), type);
	    return (T) object;
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    public String toJson() {
	try {
	    Gson gson = new Gson();
	    JsonElement ele = gson.toJsonTree(mapObject, LinkedHashMap.class);
	    return ele.toString();

	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    public String toPrettyJson() {
	try {
	    Gson gson = new GsonBuilder().setPrettyPrinting().create();

	    JsonElement ele = gson.toJsonTree(mapObject, LinkedHashMap.class);
	    return gson.toJson(ele);

	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }


    @Override
    public int hashCode() {
	return mapObject.hashCode();

    }

    public String toString() {
	try {
	    Gson gson = new Gson();
	    JsonElement ele = gson.toJsonTree(mapObject, LinkedHashMap.class);
	    return ele.toString();
	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    @Override
    public boolean equals(Object other) {
	if (other instanceof Document)
	    return other.toString().contentEquals(this.toString());
	else return false;

    }

    public static Document fromFile(String filename) {
	try {
	    FileReader filereader = new FileReader(filename);
	    BufferedReader reader = new BufferedReader(filereader);
	    String line =null;
	    StringBuilder sb = new StringBuilder();
	    while ((line=reader.readLine())!=null)
		sb.append(line);
	    reader.close();
	    if (sb.length()>0)
		return Document.parse(sb.toString());
	} catch(Exception e) {
	    e.printStackTrace();
	}
	return null;
    }

    public static Document parse(String json) {
	try {
	    JsonParser parser = new JsonParser();
	    if (json.startsWith("'") && json.endsWith("'"))
		json = json.replaceAll("'", "");

	    JsonElement p = parser.parse(json);
	    if (p.isJsonNull())
		return null;
	    if (p.isJsonObject()) {
		JsonObject _jsonObject = (JsonObject)p;
		return new Document(_jsonObject);
	    }
	    if (p.isJsonArray()) {
		JsonArray _jsonObject = (JsonArray)p;
		return new Document("list",_jsonObject);
	    }
	    return null;

	} catch (Exception e) {
	    e.printStackTrace();
	    return null;
	}
    }

    public static List<String> getJsonFromString(String input) {

	List<Character> stack = new ArrayList<Character>();
	List<String> jsons = new ArrayList<String>();
	String temp = "";
	char startBracket=';';
	char endBracket=';';

	for(char eachChar: input.toCharArray()) {
	    if (startBracket==';') {
		if (eachChar=='(') {
		    startBracket='(';
		    endBracket=')';	
		} else
		    if (eachChar=='{') {
			startBracket='{';
			endBracket='}';	
		    } else
			if (eachChar=='[') {
			    startBracket='[';
			    endBracket=']';	
			}
	    }

	    if(stack.isEmpty() && eachChar == startBracket) {
		stack.add(eachChar);
		temp += eachChar;
	    } else if(!stack.isEmpty()) {
		temp += eachChar;
		if(stack.get(stack.size()-1).equals(startBracket) && eachChar == endBracket) {
		    stack.remove(stack.size()-1);
		    if(stack.isEmpty()) {
			jsons.add(temp);
			temp = "";
		    }
		}
		else if(eachChar == startBracket || eachChar == endBracket)
		    stack.add(eachChar);
	    } else if(temp.length()>0 && stack.isEmpty()) {
		jsons.add(temp);
		temp = "";
	    }
	}
	return jsons;
    }


    public static Object parseListOrDoc(String jsonin) {
	//chop up json 
	List<String> chopper = getJsonFromString(jsonin);
	BasicDBList returned = new BasicDBList();

	for (String json : chopper) {
	    try {
		JsonParser parser = new JsonParser();
		JsonElement p = parser.parse(json);

		if (p.isJsonObject()) {
		    JsonObject _jsonObject = (JsonObject)p;
		    returned.add(new Document(_jsonObject));
		}
		if (p.isJsonArray()) {
		    JsonArray _jsonObject = (JsonArray)p;
		    BasicDBList list = new BasicDBList();
		    for (JsonElement item : _jsonObject) {
			if (item.isJsonObject())
			    list.add(new Document(item));
			else if (item.isJsonArray())
			    list.add(parseListOrDoc(item.toString()));
		    }
		    returned.add(list);
		}


	    } catch (Exception e) {
		return e.toString();
	    }
	}
	return returned;
    }

    public static Object parseListOrDocument(String json) throws Exception {
	//chop up json 
	try {
	    JsonParser parser = new JsonParser();
	    JsonElement p = parser.parse(json);

	    if (p.isJsonObject()) {
		JsonObject _jsonObject = (JsonObject)p;
		return new Document(_jsonObject);
	    }
	    if (p.isJsonArray()) {
		JsonArray _jsonObject = (JsonArray)p;
		BasicDBList list = new BasicDBList();
		for (JsonElement item : _jsonObject) {
		    if (item.isJsonObject())
			list.add(new Document(item));
		    else if (item.isJsonArray())
			list.add(parseListOrDoc(item.toString()));
		    else if (item.isJsonPrimitive())
			list.add(item.getAsJsonPrimitive());
		}
		return list;
	    }


	} catch (Exception e) {
	    throw new Exception( e.toString());
	}
	return null;

    }

    public Object remove(Object memberName) {
	Object removed = null;
	if (mapObject.containsKey((String)memberName)) {
	    removed=mapObject.get((String) memberName);
	    mapObject.remove((String)memberName);
	}
	return removed;
    }

    @Override
    public Set keySet() {	
	return mapObject.keySet();
    }

    public Set<String> keyString() {	
	return mapObject.keySet();
    }

    @Override
    public int size() {
	return mapObject.size();
    }

    @Override
    public boolean isEmpty() {
	return mapObject==null || mapObject.size()==0;
    }

    @Override
    public boolean containsValue(Object value) {
	return mapObject.containsValue(value);
    }


    @Override
    public Object put(Object key, Object value) {
	return append((String) key, value);
    }



    @Override
    public void clear() {
	mapObject=new LinkedHashMap();

    }



    @Override
    public Collection values() {
	Collection ret =  new ArrayList();
	for (Object k: mapObject.keySet()) 
	    ret.add(mapObject.get(k));
	return ret;
    }

    @Override
    public Set entrySet() {
	return mapObject.entrySet();
    }


    public <T> T get(Object memberName, Class<T> clazz) {
	Object obj=mapObject.get((String) memberName);
	if (obj != null && !(obj.getClass().isInstance(clazz)))
	    return null;
	else
	    return (T) obj;
    }

    public static String objectToString(Object o) {		
	if (o instanceof String)
	    return (String)o;
	else if (o instanceof Long)
	    return ""+(Long)o;
	else if (o instanceof Integer)
	    return ""+(Integer)o;
	else if (o instanceof Double)
	    return ""+(Double)o;
	else if (o instanceof Boolean)
	    return ""+(Boolean)o;
	else if (o instanceof Date)
	    return ""+((Date)o).toString();
	else if (o instanceof Document || o instanceof ArrayList){
	    StringBuilder sb = new StringBuilder();
	    Node.flattenDocToString("", o, sb,"");
	    return sb.toString();
	}
	else return "";
    }


    public List<String> getProperties(Collection<String> fieldNames) {

	ArrayList<StringBuilder> fullvals = new ArrayList<StringBuilder>();
	for (String colname : fieldNames){
	    String lastParent="";
	    String parent="";
	    if (colname.indexOf(".")>-1)
		parent=colname.substring(0,colname.lastIndexOf("."));
	    else 
		parent=colname;
	    Object value=getProjection(colname);
	    if (parent.equalsIgnoreCase(lastParent) /*same parent*/ || lastParent.length()==0 /*first*/){
		//append next value in sequence
		if (value!=null){
		    if (value instanceof ArrayList){
			for (int p=0; p<((ArrayList)value).size(); p++){
			    String s=Document.objectToString(((ArrayList)value).get(p))+" ";
			    if (fullvals.size()-1<p || fullvals.get(p)==null)
				fullvals.add(p, new StringBuilder(s));
			    else
				fullvals.get(p).append(s);
			}
		    } else {
			String s=Document.objectToString(value)+" ";
			if (fullvals.size()-1 <0 || fullvals.get(0)==null)
			    fullvals.add(0, new StringBuilder(s));
			else 
			    fullvals.get(0).append(s);
		    }
		}
	    } else {
		//append each value to each existing value
		for (StringBuilder fullval : fullvals){
		    if (value instanceof ArrayList){
			for (int p=0; p<((ArrayList)value).size(); p++){
			    String s=Document.objectToString(((ArrayList)value).get(p))+" ";
			    fullval.append(s);
			}
		    } else {
			String s=Document.objectToString(value)+" ";
			fullval.append(s);
		    }
		}
	    }
	    lastParent=parent;
	}
	ArrayList<String> ret = new ArrayList<String>();
	for (StringBuilder fullval : fullvals)
	    ret.add(fullval.toString().trim());
	return ret;
    }

    public Object getNative(String string) {
	return mapObject.get(string);

    }

    public String getString(String member, String defaultv) {
	String ret = getString(member);
	if (ret==null)
	    ret=defaultv;
	return ret;
    }

    public String toXML(String type) {
	org.json.JSONObject object = new org.json.JSONObject(toJson());
	return "<"+type+">"+XML.toString(object)+"</"+type+">";
    }

    public String toCSV() {
	StringBuffer sb = new StringBuffer();
	for (Object k : keySet()) {
	    sb.append(getString((String)k));
	}
	return sb.toString();
    }


    public void applyUpdate(Document amendments) {
	if (amendments.containsKey("$set")) {
	    Document setDoc = amendments.getAsDocument("$set");
	    for (Object fieldObject : setDoc.keySet()) {
		String fieldName = (String)fieldObject;
		Object value = setDoc.get(fieldObject);
		if (fieldName.contains(".")){
		    setProjection(fieldName, value);
		} else {
		    append(fieldName, value);
		}
	    }
	}
	if (amendments.containsKey("$push")) {
	    Document pushDoc = amendments.getAsDocument("$push");
	    for (Object fieldObject : pushDoc.keySet()) {
		Object supposedArray=getProjection((String)fieldObject);
		if (supposedArray instanceof List) {
		    if (pushDoc.get(fieldObject) instanceof Document) {
			Document pushDef = pushDoc.getAsDocument((String)fieldObject);
			if (pushDef.containsKey("$each")) {
			    //one would hope it does...
			    List each = pushDef.getList("$each");
			    int pos = ((List)supposedArray).size();
			    boolean usePos=false;
			    if (pushDef.containsKey("$position")) {
				usePos=true;
				pos=pushDef.getInteger("$position");
				if (pos<0) 
				    pos=((List)supposedArray).size()+pos;
				if (pos>((List)supposedArray).size())
				    usePos=false;
			    }
			    for (Object item : each) {
				if (usePos)
				    ((List)supposedArray).add(pos, item);
				else
				    ((List)supposedArray).add(item);
				pos++;
			    }
			}
		    } else {
			//its just a value to append to the end
			((List)supposedArray).add(pushDoc.get(fieldObject));
		    }
		    setProjection((String)fieldObject, supposedArray);
		}
	    }

	}


    }


    public static String stringify(List<Document> list) {
	StringBuilder d = new StringBuilder("[");
	boolean first=true;
	for (Document doc : list) {
	    if (!first)
		d.append(",");
	    d.append(doc.toJson());
	    first=false;
	}
	d.append("]");
	return d.toString();
    }




}
