package com.entitystream.monster.geo;
import com.entitystream.monster.db.*;
public class Centre implements GeoType {
        
    private Point centre;
    private double radius;
    
    public Centre(Point centre, double radius) {
        this.centre=centre;
        this.radius=radius;
       
    }

    public Point getFrom() {
        return centre;
    }

    public Point getTo() {
        return null;
    }
   
   
    public Point[] getPoints() {
        return null;
    }
    
    
    public double getRadius(){
        return radius;
    }
    
    public boolean checkInside(GeoType geo){
        if (geo instanceof Point){
          double x=((Point)geo).getX();
          double y=((Point)geo).getY();
          
          double dx = x-getFrom().getX();
          if (    dx >  getRadius() ) 
             return false;
          double dy = y-getFrom().getY();
          if (    dy >   getRadius() ) 
             return false;
          if ( dx+dy <=  getRadius() ) 
             return true;
          return ( dx*dx + dy*dy <=  getRadius()*getRadius() );
        } else if (geo instanceof LineString){
             for (Point point :  ((LineString)geo).getPoints())
                 if (!checkInside(point))
                    return false;
             return true;
        } else if (geo instanceof Line){
             return (checkInside(((Line)geo).getFrom()) &&checkInside(((Line)geo).getTo()));
        } else if (geo instanceof Polygon){
             for (Point point :  ((Polygon)geo).getPoints())
                 if (!checkInside(point))
                    return false;
             return true;
        }
        
        return false;
    }
}

